/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.felix;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceLibrarySourceFinder;
import org.osmorc.frameworkintegration.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixSourceFinder
implements FrameworkInstanceLibrarySourceFinder {
    private static final String ZIP_SOURCE_PATH = "/src/main/java";

    @Override
    public List<VirtualFile> getSourceForLibraryClasses(@NotNull VirtualFile libraryClasses) {
        ArrayList<VirtualFile> result;
        block6: {
            VirtualFile srcFolder;
            block7: {
                VirtualFile[] children;
                if (libraryClasses == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/felix/FelixSourceFinder.getSourceForLibraryClasses must not be null");
                }
                result = new ArrayList<VirtualFile>();
                VirtualFile bundleFolder = libraryClasses.getParent();
                assert (bundleFolder != null);
                VirtualFile felixFolder = bundleFolder.getParent();
                assert (felixFolder != null);
                srcFolder = felixFolder.findChild("src");
                if (srcFolder == null) break block6;
                if (!bundleFolder.getName().equals("bin")) break block7;
                VirtualFile binFolder = srcFolder.findChild("bin");
                if (binFolder == null) break block6;
                for (VirtualFile child : children = binFolder.getChildren()) {
                    this.addIfSource(child, result);
                }
                break block6;
            }
            VirtualFile srcBundleFolder = srcFolder.findChild("bundle");
            if (srcBundleFolder != null) {
                VirtualFile[] children;
                for (VirtualFile child : children = srcBundleFolder.getChildren()) {
                    this.addIfSource(libraryClasses, child, result);
                }
            }
        }
        return result;
    }

    @Override
    public boolean containsOnlySources(@NotNull VirtualFile libraryClassesCondidate) {
        if (libraryClassesCondidate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/felix/FelixSourceFinder.containsOnlySources must not be null");
        }
        return false;
    }

    private void addIfSource(VirtualFile sourceZIP, List<VirtualFile> result) {
        String name;
        VirtualFile sourceFolder;
        VirtualFile folder = FileUtil.getFolder(sourceZIP);
        if (folder != null && (sourceFolder = folder.findFileByRelativePath((name = FileUtil.getNameWithoutTail(FileUtil.getNameWithoutTail(sourceZIP, ".zip"), "-project")) + ZIP_SOURCE_PATH)) != null && sourceFolder.isDirectory()) {
            result.add(sourceFolder);
        }
    }

    private void addIfSource(VirtualFile libraryClasses, VirtualFile sourceZIP, List<VirtualFile> result) {
        VirtualFile sourceFolder;
        String sourceName;
        String classesName;
        VirtualFile folder = FileUtil.getFolder(sourceZIP);
        if (folder != null && (classesName = FileUtil.getNameWithoutTail(libraryClasses, ".jar")).contains(sourceName = FileUtil.getNameWithoutTail(FileUtil.getNameWithoutTail(sourceZIP, ".zip"), "-project")) && (sourceFolder = folder.findFileByRelativePath(sourceName + ZIP_SOURCE_PATH)) != null && sourceFolder.isDirectory()) {
            result.add(sourceFolder);
        }
    }
}

