/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.knopflerfish;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.LibraryHandler;
import org.osmorc.frameworkintegration.impl.knopflerfish.KnopflerfishSourceFinder;
import org.osmorc.i18n.OsmorcBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnopflerfishFrameworkInstanceManager
implements FrameworkInstanceManager {
    private final LibraryHandler _libraryHandler;
    private final LocalFileSystem _fileSystem;
    private final Application _application;

    public KnopflerfishFrameworkInstanceManager(LibraryHandler libraryHandler, LocalFileSystem fileSystem, Application application) {
        this._libraryHandler = libraryHandler;
        this._fileSystem = fileSystem;
        this._application = application;
    }

    @Override
    public void createLibraries(final FrameworkInstanceDefinition frameworkInstanceDefinition) {
        VirtualFile installFolder = this._fileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        if (installFolder == null) {
            throw new RuntimeException("The folder " + frameworkInstanceDefinition.getBaseFolder() + " does not exist.");
        }
        if (!installFolder.isDirectory()) {
            throw new RuntimeException(frameworkInstanceDefinition.getBaseFolder() + " is not a folder");
        }
        VirtualFile knopflerfishOrgFolder = installFolder.findChild("knopflerfish.org");
        if (knopflerfishOrgFolder == null) {
            throw new RuntimeException(installFolder.getPath() + " does not contain a folder \"knopflerfish.org\"");
        }
        final VirtualFile osgiFolder = knopflerfishOrgFolder.findChild("osgi");
        if (osgiFolder == null) {
            throw new RuntimeException(knopflerfishOrgFolder.getPath() + " does not contain a folder \"osgi\"");
        }
        this._application.runWriteAction(new Runnable(){

            public void run() {
                osgiFolder.refresh(false, true);
                KnopflerfishSourceFinder sourceFinder = new KnopflerfishSourceFinder(osgiFolder);
                KnopflerfishFrameworkInstanceManager.this._libraryHandler.startLibraryChanges();
                KnopflerfishFrameworkInstanceManager.this._libraryHandler.createLibrariesFromBundles(osgiFolder, frameworkInstanceDefinition.getName(), sourceFinder);
                VirtualFile jarsFolder = osgiFolder.findChild("jars");
                if (jarsFolder != null) {
                    VirtualFile[] files;
                    if (!jarsFolder.isDirectory()) {
                        throw new RuntimeException(jarsFolder.getPath() + " is not a folder");
                    }
                    for (VirtualFile file : files = jarsFolder.getChildren()) {
                        if (!file.isDirectory()) continue;
                        KnopflerfishFrameworkInstanceManager.this._libraryHandler.createLibrariesFromBundles(file, frameworkInstanceDefinition.getName(), sourceFinder);
                    }
                }
                KnopflerfishFrameworkInstanceManager.this._libraryHandler.commitLibraryChanges();
            }
        });
    }

    @Override
    public void removeLibraries(final FrameworkInstanceDefinition frameworkInstanceDefinition) {
        this._application.runWriteAction(new Runnable(){

            public void run() {
                KnopflerfishFrameworkInstanceManager.this._libraryHandler.startLibraryChanges();
                KnopflerfishFrameworkInstanceManager.this._libraryHandler.deleteLibraries(frameworkInstanceDefinition.getName());
                KnopflerfishFrameworkInstanceManager.this._libraryHandler.commitLibraryChanges();
            }
        });
    }

    @Override
    public List<Library> getLibraries(FrameworkInstanceDefinition frameworkInstanceDefinition) {
        return this._libraryHandler.getLibraries(frameworkInstanceDefinition.getName());
    }

    @Override
    public String checkValidity(@NotNull FrameworkInstanceDefinition frameworkInstanceDefinition) {
        if (frameworkInstanceDefinition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishFrameworkInstanceManager.checkValidity must not be null");
        }
        if (frameworkInstanceDefinition.getName() == null || frameworkInstanceDefinition.getName().trim().length() == 0) {
            return "A name for the framework instance needs to be given.";
        }
        VirtualFile installFolder = this._fileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        if (installFolder == null || !installFolder.isDirectory()) {
            return OsmorcBundle.getTranslation("knopflerfish.folder.does.not.exist", frameworkInstanceDefinition.getBaseFolder());
        }
        VirtualFile knopflerfishOrgFolder = installFolder.findChild("knopflerfish.org");
        if (knopflerfishOrgFolder == null || !knopflerfishOrgFolder.isDirectory()) {
            return OsmorcBundle.getTranslation("knopflerfish.folder.knopflerfish.org.missing", frameworkInstanceDefinition.getBaseFolder());
        }
        VirtualFile osgiFolder = knopflerfishOrgFolder.findChild("osgi");
        if (osgiFolder == null || !osgiFolder.isDirectory()) {
            return OsmorcBundle.getTranslation("knopflerfish.folder.osgi.missing", knopflerfishOrgFolder.getPath());
        }
        VirtualFile jarsFolder = osgiFolder.findChild("jars");
        if (jarsFolder == null || !jarsFolder.isDirectory()) {
            return OsmorcBundle.getTranslation("knopflerfish.folder.jars.missing", osgiFolder.getPath());
        }
        return null;
    }
}

