/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.knopflerfish;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceLibrarySourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnopflerfishSourceFinder
implements FrameworkInstanceLibrarySourceFinder {
    @NonNls
    private final Map<String, VirtualFile> _sourceMapping;

    public KnopflerfishSourceFinder(@NotNull VirtualFile osgiFolder) {
        VirtualFile frameworkFolder;
        if (osgiFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishSourceFinder.<init> must not be null");
        }
        this._sourceMapping = new HashMap();
        VirtualFile bundlesFolder = osgiFolder.findChild("bundles");
        if (bundlesFolder != null) {
            this.findSources(bundlesFolder);
        }
        if ((frameworkFolder = osgiFolder.findFileByRelativePath("framework/src")) != null) {
            this._sourceMapping.put("framework", frameworkFolder);
        }
    }

    private void findSources(VirtualFile folder) {
        VirtualFile sourceFolder = folder.findChild("src");
        if (sourceFolder != null) {
            this._sourceMapping.put(folder.getName(), sourceFolder);
        } else {
            VirtualFile[] files;
            for (VirtualFile file : files = folder.getChildren()) {
                if (!file.isDirectory()) continue;
                this.findSources(file);
            }
        }
    }

    @Override
    public List<VirtualFile> getSourceForLibraryClasses(@NotNull VirtualFile libraryClasses) {
        if (libraryClasses == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishSourceFinder.getSourceForLibraryClasses must not be null");
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        if (libraryClasses.getNameWithoutExtension().equals("framework")) {
            VirtualFile frameworkSources = this._sourceMapping.get("framework");
            if (frameworkSources != null) {
                result.add(frameworkSources);
            }
        } else {
            String parentFolderName = libraryClasses.getParent().getName();
            VirtualFile sources = this._sourceMapping.get(parentFolderName);
            if (sources != null) {
                result.add(sources);
            }
        }
        return result;
    }

    @Override
    public boolean containsOnlySources(@NotNull VirtualFile libraryClassesCondidate) {
        if (libraryClassesCondidate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishSourceFinder.containsOnlySources must not be null");
        }
        return false;
    }
}

