/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.util;

import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    public static String getNameWithoutJarSuffix(@NotNull VirtualFile libraryClasses) {
        if (libraryClasses == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/util/FileUtil.getNameWithoutJarSuffix must not be null");
        }
        return FileUtil.getNameWithoutTail(libraryClasses, ".jar");
    }

    public static String getNameWithoutTail(@NotNull VirtualFile libraryClasses, @NotNull String tail) {
        if (libraryClasses == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/util/FileUtil.getNameWithoutTail must not be null");
        }
        if (tail == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/frameworkintegration/util/FileUtil.getNameWithoutTail must not be null");
        }
        return FileUtil.getNameWithoutTail(libraryClasses.getName(), tail);
    }

    public static String getNameWithoutTail(@NotNull String name, @NotNull String tail) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/util/FileUtil.getNameWithoutTail must not be null");
        }
        if (tail == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/frameworkintegration/util/FileUtil.getNameWithoutTail must not be null");
        }
        if (name.toLowerCase().endsWith(tail.toLowerCase())) {
            return name.substring(0, name.length() - tail.length());
        }
        return name;
    }

    public static VirtualFile getFolder(@Nullable VirtualFile file) {
        VirtualFile result = null;
        if (file != null) {
            result = file.isDirectory() ? file : JarFileSystem.getInstance().getJarRootForLocalFile(file);
        }
        return result;
    }
}

