/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.util;

import com.jgoodies.binding.beans.Model;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesWrapper
extends Model {
    private Map<String, String> _properties = new HashMap<String, String>();

    public PropertiesWrapper(Map<String, String> properties) {
        this.loadDefaults();
        this._properties.putAll(properties);
    }

    protected String getProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/util/PropertiesWrapper.getProperty must not be null");
        }
        return this._properties.get(name);
    }

    protected void putProperty(@NotNull String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/util/PropertiesWrapper.putProperty must not be null");
        }
        if (this.isBooleanProperty(name)) {
            this.putBooleanProperty(name, Boolean.parseBoolean(value));
        } else {
            String old = this.getProperty(name);
            this._properties.put(name, value);
            this.firePropertyChange(name, old, value);
        }
    }

    protected boolean getBooleanProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/util/PropertiesWrapper.getBooleanProperty must not be null");
        }
        return Boolean.parseBoolean(this.getProperty(name));
    }

    protected void putBooleanProperty(@NotNull String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/util/PropertiesWrapper.putBooleanProperty must not be null");
        }
        boolean old = this.getBooleanProperty(name);
        this._properties.put(name, String.valueOf(value));
        this.firePropertyChange(name, old, value);
    }

    public void load(Map<String, String> additionalProperties) {
        for (String key : additionalProperties.keySet()) {
            this.putProperty(key, additionalProperties.get(key));
        }
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    private boolean isBooleanProperty(String name) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(name, ((Object)((Object)this)).getClass());
            return Boolean.class.isAssignableFrom(pd.getPropertyType()) || Boolean.TYPE.isAssignableFrom(pd.getPropertyType());
        }
        catch (IntrospectionException e) {
            return false;
        }
    }

    protected void loadDefaults() {
    }
}

