/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.i18n;

import com.intellij.CommonBundle;
import com.intellij.openapi.util.IconLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.PropertyKey;

public class OsmorcBundle {
    private static Reference<ResourceBundle> _ourBundle;
    private static String infoHtml;
    private static Map<String, Icon> _iconCache;
    @NonNls
    private static final String BUNDLE = "org.osmorc.i18n.OsmorcBundle";

    private OsmorcBundle() {
    }

    @Deprecated
    public static String getTranslation(@PropertyKey(resourceBundle="org.osmorc.i18n.OsmorcBundle") String key, Object ... params) {
        return CommonBundle.message((ResourceBundle)OsmorcBundle.getBundle(), (String)key, (Object[])params);
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = null;
        if (_ourBundle != null) {
            bundle = _ourBundle.get();
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            _ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    private static Icon getCachedIcon(@PropertyKey(resourceBundle="org.osmorc.i18n.OsmorcBundle") String property) {
        Icon result = _iconCache.get(property);
        if (result == null) {
            result = IconLoader.getIcon((String)OsmorcBundle.getTranslation(property, new Object[0]));
            _iconCache.put(property, result);
        }
        return result;
    }

    public static Icon getSmallIcon() {
        return OsmorcBundle.getCachedIcon("runconfiguration.icon");
    }

    public static Icon getBigIcon() {
        return OsmorcBundle.getCachedIcon("projectconfiguration.icon");
    }

    public static Icon getLogo() {
        return OsmorcBundle.getCachedIcon("logo.icon");
    }

    public static String getInfo() {
        if (infoHtml == null) {
            StringBuilder builder = new StringBuilder();
            InputStream stream = null;
            InputStreamReader streamReader = null;
            BufferedReader bReader = null;
            try {
                String infoFileName = OsmorcBundle.getTranslation("info.file", new Object[0]);
                stream = OsmorcBundle.class.getResourceAsStream(infoFileName);
                streamReader = new InputStreamReader(stream);
                bReader = new BufferedReader(streamReader);
                while (bReader.ready()) {
                    builder.append(bReader.readLine());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (bReader != null) {
                        bReader.close();
                    }
                    if (streamReader != null) {
                        streamReader.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            infoHtml = builder.toString();
        }
        return infoHtml;
    }

    static {
        _iconCache = new WeakHashMap<String, Icon>();
    }
}

