/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osmorc.AdditionalJARContentsWatcherManager;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetUtil;

public class AdditionalJARContentsWatcherManagerImpl
implements AdditionalJARContentsWatcherManager {
    private final Logger logger = Logger.getInstance((String)"#org.osmorc.impl.AdditionalJARContentsWatcherManagerImpl");
    private LocalFileSystem _fileSystem;
    private List<VirtualFile> _additionalBundleJARContents;
    private List<LocalFileSystem.WatchRequest> _watchRequests;
    private Module _module;
    private OsmorcFacetUtil _osmorcFacetUtil;

    public AdditionalJARContentsWatcherManagerImpl(Module module, OsmorcFacetUtil osmorcFacetUtil, LocalFileSystem fileSystem) {
        this._module = module;
        this._osmorcFacetUtil = osmorcFacetUtil;
        this._fileSystem = fileSystem;
        this._additionalBundleJARContents = new ArrayList<VirtualFile>();
        this._watchRequests = new ArrayList<LocalFileSystem.WatchRequest>();
        this.updateWatcherSetup();
    }

    public void updateWatcherSetup() {
        if (this._osmorcFacetUtil.hasOsmorcFacet(this._module)) {
            OsmorcFacet osmorcFacet = this._osmorcFacetUtil.getOsmorcFacet(this._module);
            ArrayList<VirtualFile> newAdditionalJARContents = new ArrayList<VirtualFile>();
            OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
            List<Pair<String, String>> jarContents = osmorcFacetConfiguration.getAdditionalJARContents();
            for (Pair<String, String> jarContent : jarContents) {
                VirtualFile file = this._fileSystem.findFileByPath((String)jarContent.getFirst());
                if (file == null) continue;
                newAdditionalJARContents.add(file);
            }
            Iterator<VirtualFile> jarContentsIterator = this._additionalBundleJARContents.iterator();
            while (jarContentsIterator.hasNext()) {
                VirtualFile file = jarContentsIterator.next();
                if (newAdditionalJARContents.contains(file)) continue;
                jarContentsIterator.remove();
                Iterator<LocalFileSystem.WatchRequest> watchIterator = this._watchRequests.iterator();
                while (watchIterator.hasNext()) {
                    LocalFileSystem.WatchRequest watchRequest = watchIterator.next();
                    if (!Comparing.strEqual((String)file.getPath(), (String)watchRequest.getRootPath())) continue;
                    this._fileSystem.removeWatchedRoot(watchRequest);
                    watchIterator.remove();
                }
            }
            for (VirtualFile newAdditionalJARContent : newAdditionalJARContents) {
                if (this._additionalBundleJARContents.contains(newAdditionalJARContent)) continue;
                LocalFileSystem.WatchRequest watchRequest = this._fileSystem.addRootToWatch(newAdditionalJARContent.getPath(), true);
                if (watchRequest != null) {
                    this._watchRequests.add(watchRequest);
                } else {
                    this.logger.warn("It seems like " + newAdditionalJARContent.getPath() + " doesn't belong to the file system or the file watcher is not operational.");
                }
                this._additionalBundleJARContents.add(newAdditionalJARContent);
            }
        } else {
            this._additionalBundleJARContents.clear();
            for (LocalFileSystem.WatchRequest watchRequest : this._watchRequests) {
                this._fileSystem.removeWatchedRoot(watchRequest);
            }
            this._watchRequests.clear();
        }
    }

    public void dispose() {
        for (LocalFileSystem.WatchRequest watchRequest : this._watchRequests) {
            this._fileSystem.removeWatchedRoot(watchRequest);
        }
        this._watchRequests.clear();
        this._additionalBundleJARContents.clear();
    }
}

