/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleException;
import org.osmorc.BundleManager;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.manifest.BundleManifest;
import org.osmorc.manifest.ManifestHolder;
import org.osmorc.manifest.ManifestHolderRegistry;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.ProjectSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManagerImpl
implements BundleManager {
    private final ModuleManager moduleManager;
    private final ManifestHolderRegistry manifestHolderRegistry;
    private final FrameworkIntegratorRegistry frameworkIntegratorRegistry;
    private final ProjectSettings projectSettings;
    private final ApplicationSettings applicationSettings;
    private State _state;
    private static final Logger LOG = Logger.getInstance((String)"org.osmorc.BundleManagerImpl");
    private String _currentFrameworkInstanceName;

    public BundleManagerImpl(ModuleManager moduleManager, ManifestHolderRegistry manifestHolderRegistry, FrameworkIntegratorRegistry frameworkIntegratorRegistry, ProjectSettings projectSettings, ApplicationSettings applicationSettings) {
        this.moduleManager = moduleManager;
        this.manifestHolderRegistry = manifestHolderRegistry;
        this.frameworkIntegratorRegistry = frameworkIntegratorRegistry;
        this.projectSettings = projectSettings;
        this.applicationSettings = applicationSettings;
    }

    public Object findBundle(String bundleSymbolicName) {
        Module[] modules;
        for (Module module : modules = this.moduleManager.getModules()) {
            BundleManifest bundleManifest = this.getBundleManifest(module);
            if (bundleManifest == null || !bundleSymbolicName.equals(bundleManifest.getBundleSymbolicName())) continue;
            return module;
        }
        List<Library> libraries = this.getFrameworkInstanceLibraries();
        for (Library library : libraries) {
            BundleManifest bundleManifest = this.getBundleManifest(library);
            if (bundleManifest == null || !bundleSymbolicName.equals(bundleManifest.getBundleSymbolicName())) continue;
            return library;
        }
        return null;
    }

    @Override
    public BundleManifest getBundleManifest(String bundleSymbolicName) {
        Object bundle = this.findBundle(bundleSymbolicName);
        if (bundle != null) {
            return this.getBundleManifest(bundle);
        }
        return null;
    }

    @Override
    public BundleManifest getBundleManifest(@NotNull Object bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.getBundleManifest must not be null");
        }
        return this.getManifestHolder(bundle).getBundleManifest();
    }

    @Override
    public void addOrUpdateBundle(@NotNull Object bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.addOrUpdateBundle must not be null");
        }
        this.createInitialState();
        this.addOrUpdateBundleInternal(bundle);
        this._state.resolve();
    }

    private void addOrUpdateBundleInternal(Object bundle) {
        BundleManifest bundleManifest = this.getBundleManifest(bundle);
        if (bundleManifest != null) {
            try {
                BundleDescription oldDescription = this.getBundleDescription(bundle);
                BundleDescription bundleDescription = this.createBundleDescription(bundleManifest, oldDescription != null ? oldDescription.getBundleId() : this._state.getHighestBundleId() + 1L);
                if (bundleDescription != null) {
                    this.getManifestHolder(bundle).setBundleID(bundleDescription.getBundleId());
                    bundleDescription.setUserObject(bundle);
                    if (oldDescription != null) {
                        this._state.updateBundle(bundleDescription);
                    } else {
                        this._state.addBundle(bundleDescription);
                    }
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public BundleDescription getBundleDescription(Object bundle) {
        long bundleID = this.getManifestHolder(bundle).getBundleID();
        return bundleID >= 0L ? this._state.getBundle(bundleID) : null;
    }

    @Override
    public Collection<Object> determineBundleDependencies(@NotNull Object bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.determineBundleDependencies must not be null");
        }
        this.createInitialState();
        HashSet<Object> result = new HashSet<Object>();
        BundleDescription bundleDescription = this.getBundleDescription(bundle);
        if (bundleDescription == null && bundle instanceof Module && OsmorcFacet.hasOsmorcFacet((Module)bundle)) {
            this.addOrUpdateBundle(bundle);
            bundleDescription = this.getBundleDescription(bundle);
        }
        if (bundleDescription != null) {
            List<BundleDescription> resolvedRequires = this.getResolvedRequires(bundle);
            for (BundleDescription resolvedRequire : resolvedRequires) {
                Object resolvedRequiredBundle = resolvedRequire.getUserObject();
                result.add(resolvedRequiredBundle);
                result.addAll(this.determineReexportedRequiredBundlesOnLibraries(resolvedRequiredBundle));
            }
            List<ExportPackageDescription> resolvedImports = this.getResolvedImports(bundle);
            for (ExportPackageDescription resolvedImport : resolvedImports) {
                result.add(resolvedImport.getExporter().getUserObject());
            }
            result.addAll(this.getFragments(result));
            HostSpecification hostSpecification = bundleDescription.getHost();
            if (hostSpecification != null && hostSpecification.getHosts() != null) {
                for (BundleDescription hostBundleDescription : hostSpecification.getHosts()) {
                    result.add(hostBundleDescription.getUserObject());
                }
            }
            result.remove(bundle);
        }
        return result;
    }

    @Override
    public List<BundleDescription> getResolvedRequires(@NotNull Object bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.getResolvedRequires must not be null");
        }
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>();
        BundleDescription bundleDescription = this.getBundleDescription(bundle);
        if (bundleDescription != null) {
            result.addAll(Arrays.asList(bundleDescription.getResolvedRequires()));
            HostSpecification hostSpecification = bundleDescription.getHost();
            if (hostSpecification != null && hostSpecification.getHosts() != null) {
                for (BundleDescription hostBundleDescription : hostSpecification.getHosts()) {
                    result.addAll(this.getResolvedRequires(hostBundleDescription.getUserObject()));
                }
            }
        }
        return result;
    }

    private List<BundleSpecification> getRequiredBundles(@NotNull Object bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.getRequiredBundles must not be null");
        }
        ArrayList<BundleSpecification> result = new ArrayList<BundleSpecification>();
        BundleDescription bundleDescription = this.getBundleDescription(bundle);
        if (bundleDescription != null) {
            result.addAll(Arrays.asList(bundleDescription.getRequiredBundles()));
            HostSpecification hostSpecification = bundleDescription.getHost();
            if (hostSpecification != null && hostSpecification.getHosts() != null) {
                for (BundleDescription hostBundleDescription : hostSpecification.getHosts()) {
                    result.addAll(this.getRequiredBundles(hostBundleDescription.getUserObject()));
                }
            }
        }
        return result;
    }

    @Override
    public List<ExportPackageDescription> getResolvedImports(@NotNull Object bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.getResolvedImports must not be null");
        }
        ArrayList<ExportPackageDescription> result = new ArrayList<ExportPackageDescription>();
        BundleDescription bundleDescription = this.getBundleDescription(bundle);
        if (bundleDescription != null) {
            result.addAll(Arrays.asList(bundleDescription.getResolvedImports()));
            HostSpecification hostSpecification = bundleDescription.getHost();
            if (hostSpecification != null && hostSpecification.getHosts() != null) {
                for (BundleDescription hostBundleDescription : hostSpecification.getHosts()) {
                    result.addAll(this.getResolvedImports(hostBundleDescription.getUserObject()));
                }
            }
        }
        return result;
    }

    private Collection<Object> getFragments(Collection<Object> bundles) {
        HashSet<Object> result = new HashSet<Object>();
        for (Object bundle : bundles) {
            BundleDescription[] fragments;
            BundleDescription bundleDescription = this.getBundleDescription(bundle);
            if (bundleDescription == null || (fragments = bundleDescription.getFragments()) == null) continue;
            for (BundleDescription fragment : fragments) {
                result.add(fragment.getUserObject());
            }
        }
        return result;
    }

    private Collection<Object> determineReexportedRequiredBundlesOnLibraries(@NotNull Object bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.determineReexportedRequiredBundlesOnLibraries must not be null");
        }
        HashSet<Object> result = new HashSet<Object>();
        if (bundle instanceof Library) {
            List<BundleDescription> resolvedRequires = this.getResolvedRequires(bundle);
            List<BundleSpecification> requiredBundles = this.getRequiredBundles(bundle);
            if (requiredBundles != null && requiredBundles.size() > 0) {
                for (BundleSpecification requiredBundle : requiredBundles) {
                    if (!requiredBundle.isExported()) continue;
                    for (BundleDescription resolvedRequire : resolvedRequires) {
                        if (!requiredBundle.isSatisfiedBy((BaseDescription)resolvedRequire)) continue;
                        Object resolvedRequiredBundle = resolvedRequire.getUserObject();
                        result.add(resolvedRequiredBundle);
                        result.addAll(this.determineReexportedRequiredBundlesOnLibraries(resolvedRequiredBundle));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isReexported(@NotNull Object reexportCandidate, @NotNull Object exporter) {
        if (reexportCandidate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.isReexported must not be null");
        }
        if (exporter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.isReexported must not be null");
        }
        BundleDescription reexportCandidateDescription = this.getBundleDescription(reexportCandidate);
        if (reexportCandidateDescription != null) {
            BundleSpecification[] requiredBundles;
            BundleDescription exporterDescription;
            HostSpecification hostSpecification = reexportCandidateDescription.getHost();
            if (hostSpecification != null && hostSpecification.getHosts() != null) {
                for (BundleDescription hostBundleDescription : hostSpecification.getHosts()) {
                    if (!this.isReexported(hostBundleDescription.getUserObject(), exporter)) continue;
                    return true;
                }
            }
            if ((exporterDescription = this.getBundleDescription(exporter)) != null && (requiredBundles = exporterDescription.getRequiredBundles()) != null && requiredBundles.length > 0) {
                for (BundleSpecification requiredBundle : requiredBundles) {
                    if (!requiredBundle.isSatisfiedBy((BaseDescription)reexportCandidateDescription)) continue;
                    return requiredBundle.isExported();
                }
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<Object> getHostBundles(@NotNull Object bundle) {
        HostSpecification hostSpecification;
        BundleDescription[] hosts;
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.getHostBundles must not be null");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        BundleDescription bundleDescription = this.getBundleDescription(bundle);
        if (bundleDescription != null && bundleDescription.getHost() != null && (hosts = (hostSpecification = bundleDescription.getHost()).getHosts()) != null) {
            for (BundleDescription host : hosts) {
                result.add(host.getUserObject());
            }
        }
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/impl/BundleManagerImpl.getHostBundles must not return null");
        }
        return arrayList;
    }

    @Override
    public boolean reloadFrameworkInstanceLibraries(boolean onlyIfFrameworkInstanceSelectionChanged) {
        String frameworkInstanceName = this.projectSettings.getFrameworkInstanceName();
        if (!onlyIfFrameworkInstanceSelectionChanged || frameworkInstanceName != null && !frameworkInstanceName.equals(this._currentFrameworkInstanceName)) {
            if (this._state == null) {
                this.createInitialState();
            } else {
                List<Long> longs = this.manifestHolderRegistry.getLibraryBundleIDs();
                for (Long libraryBundleID : longs) {
                    this._state.removeBundle(libraryBundleID.longValue());
                }
                this.manifestHolderRegistry.clearLibraryManifestHolders();
                this.loadFrameworkInstanceLibraryBundles();
                this._state.resolve();
            }
            return true;
        }
        return false;
    }

    private BundleDescription createBundleDescription(BundleManifest bundleManifest, long bundleID) throws IOException {
        BundleDescription bundleDescription = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream((bundleManifest.getManifestFile().getText() + "\n").getBytes());
            Manifest manifest = new Manifest(inputStream);
            Attributes mainAttributes = manifest.getMainAttributes();
            Properties properties = new Properties();
            for (Object attributeKey : mainAttributes.keySet()) {
                properties.put(attributeKey.toString(), mainAttributes.get(attributeKey));
            }
            bundleDescription = StateObjectFactory.defaultFactory.createBundleDescription(this._state, (Dictionary)properties, null, bundleID);
        }
        catch (BundleException e) {
            LOG.debug((Throwable)e);
        }
        catch (NumberFormatException e) {
            LOG.debug((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Throwable)e);
        }
        return bundleDescription;
    }

    private synchronized void createInitialState() {
        if (this._state == null) {
            Module[] modules;
            this._state = StateObjectFactory.defaultFactory.createState(true);
            Resolver resolver = this._state.getResolver();
            if (resolver instanceof ResolverImpl) {
                try {
                    Field minTime = ResolverImpl.class.getDeclaredField("MAX_USES_TIME_BASE");
                    minTime.setAccessible(true);
                    minTime.set(null, 1000);
                    Field maxTime = ResolverImpl.class.getDeclaredField("MAX_USES_TIME_LIMIT");
                    maxTime.setAccessible(true);
                    maxTime.set(null, 3000);
                }
                catch (NoSuchFieldException e) {
                    LOG.warn((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOG.warn((Throwable)e);
                }
            }
            for (Module module : modules = this.moduleManager.getModules()) {
                this.addOrUpdateBundleInternal(module);
            }
            this.loadFrameworkInstanceLibraryBundles();
            Properties platformProperties = new Properties();
            platformProperties.put("osgi.resolverMode", "development");
            this._state.setPlatformProperties((Dictionary)platformProperties);
            this._state.resolve();
        }
    }

    private void loadFrameworkInstanceLibraryBundles() {
        this._currentFrameworkInstanceName = this.projectSettings.getFrameworkInstanceName();
        if (this._currentFrameworkInstanceName != null) {
            List<Library> libraries = this.getFrameworkInstanceLibraries();
            for (Library library : libraries) {
                this.addOrUpdateBundleInternal(library);
            }
        }
    }

    private List<Library> getFrameworkInstanceLibraries() {
        FrameworkInstanceDefinition frameworkInstanceDefinition = this.applicationSettings.getFrameworkInstance(this.projectSettings.getFrameworkInstanceName());
        List<Library> libraries = null;
        if (frameworkInstanceDefinition != null) {
            FrameworkIntegrator frameworkIntegrator = this.frameworkIntegratorRegistry.findIntegratorByInstanceDefinition(frameworkInstanceDefinition);
            libraries = frameworkIntegrator.getFrameworkInstanceManager().getLibraries(frameworkInstanceDefinition);
        }
        if (libraries == null) {
            libraries = Collections.emptyList();
        }
        return libraries;
    }

    protected ManifestHolder getManifestHolder(Object bundle) {
        return this.manifestHolderRegistry.getManifestHolder(bundle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getDisplayName(@NotNull Object bundle) {
        String string;
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/impl/BundleManagerImpl.getDisplayName must not be null");
        }
        if (bundle instanceof Module) {
            String string2 = ((Module)bundle).getName();
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method org/osmorc/impl/BundleManagerImpl.getDisplayName must not return null");
        }
        if (bundle instanceof Library) {
            String libName = ((Library)bundle).getName();
            if (libName == null) {
                VirtualFile[] files = ((Library)bundle).getFiles(OrderRootType.CLASSES);
                if (files.length <= 0) return "unnamed library";
                VirtualFile file = files[0];
                if (file == null) return "unnamed library";
                String string3 = file.getName();
                string = string3;
                if (string3 == null) throw new IllegalStateException("@NotNull method org/osmorc/impl/BundleManagerImpl.getDisplayName must not return null");
                return string;
            }
            String string4 = libName;
            string = string4;
            if (string4 == null) throw new IllegalStateException("@NotNull method org/osmorc/impl/BundleManagerImpl.getDisplayName must not return null");
            return string;
        }
        String string5 = bundle.toString();
        string = string5;
        if (string5 == null) throw new IllegalStateException("@NotNull method org/osmorc/impl/BundleManagerImpl.getDisplayName must not return null");
        return string;
    }
}

