/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.facet.OsmorcFacet;

public class ClassInDefaultPackageInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("OSGi" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassInDefaultPackageInspection.getGroupDisplayName must not return null");
        }
        return "OSGi";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassInDefaultPackageInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Class is in default package" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassInDefaultPackageInspection.getDisplayName must not return null");
        }
        return "Class is in default package";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("osmorcClassInDefaultPackage" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassInDefaultPackageInspection.getShortName must not return null");
        }
        return "osmorcClassInDefaultPackage";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/ClassInDefaultPackageInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitClass(PsiClass psiClass) {
                PsiIdentifier nameIdentifier;
                PsiJavaFile file;
                if (OsmorcFacet.hasOsmorcFacet((PsiElement)psiClass) && "".equals((file = (PsiJavaFile)psiClass.getContainingFile()).getPackageName()) && (nameIdentifier = psiClass.getNameIdentifier()) != null) {
                    holder.registerProblem((PsiElement)nameIdentifier, "Class is in default package", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassInDefaultPackageInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }
}

