/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.BundleManager;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.frameworkintegration.LibraryHandler;
import org.osmorc.inspection.AvailabilityCheckResult;
import org.osmorc.settings.ProjectSettings;

public class ClassUnavailableInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("OSGi" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassUnavailableInspection.getGroupDisplayName must not return null");
        }
        return "OSGi";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassUnavailableInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unavailable in OSGi container" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassUnavailableInspection.getDisplayName must not return null");
        }
        return "Unavailable in OSGi container";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("osmorcInvalidImport" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassUnavailableInspection.getShortName must not return null");
        }
        return "osmorcInvalidImport";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitNewExpression(PsiNewExpression expression) {
                AvailabilityCheckResult result;
                PsiJavaCodeReferenceElement classReference;
                if (OsmorcFacet.hasOsmorcFacet((PsiElement)expression) && ((OsmorcFacetConfiguration)OsmorcFacet.getInstance((PsiElement)expression).getConfiguration()).isManifestManuallyEdited() && (classReference = expression.getClassReference()) != null && !(result = ClassUnavailableInspection.this.checkElement(classReference.resolve(), ModuleUtil.findModuleForPsiElement((PsiElement)expression))).isOk()) {
                    holder.registerProblem((PsiElement)expression, result.getDescription(), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                }
            }

            public void visitVariable(PsiVariable variable) {
                if (OsmorcFacet.hasOsmorcFacet((PsiElement)variable) && ((OsmorcFacetConfiguration)OsmorcFacet.getInstance((PsiElement)variable).getConfiguration()).isManifestManuallyEdited()) {
                    AvailabilityCheckResult result;
                    PsiClass psiClass = null;
                    PsiType psiType = variable.getType();
                    if (psiType instanceof PsiClassType) {
                        psiClass = ((PsiClassType)psiType).resolve();
                    }
                    if (!(result = ClassUnavailableInspection.this.checkElement((PsiElement)psiClass, ModuleUtil.findModuleForPsiElement((PsiElement)variable))).isOk()) {
                        holder.registerProblem((PsiElement)variable, result.getDescription(), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                    }
                }
            }

            public void visitImportStatement(PsiImportStatement statement) {
                if (OsmorcFacet.hasOsmorcFacet((PsiElement)statement) && ((OsmorcFacetConfiguration)OsmorcFacet.getInstance((PsiElement)statement).getConfiguration()).isManifestManuallyEdited()) {
                    AvailabilityCheckResult result;
                    PsiJavaCodeReferenceElement importReference;
                    PsiElement element = statement.resolve();
                    if (element == null && (importReference = statement.getImportReference()) != null) {
                        PsiReference reference;
                        String importText = importReference.getText();
                        if (importText.endsWith(";")) {
                            importText = importText.substring(0, importText.length() - 1);
                        }
                        if (importText.endsWith(".*")) {
                            importText = importText.substring(0, importText.length() - 2);
                        }
                        if ((reference = importReference.findReferenceAt(importText.length() - 1)) != null) {
                            element = reference.resolve();
                        }
                    }
                    if (!(result = ClassUnavailableInspection.this.checkElement(element, ModuleUtil.findModuleForPsiElement((PsiElement)statement))).isOk()) {
                        holder.registerProblem((PsiElement)statement, result.getDescription(), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassUnavailableInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    @NotNull
    protected AvailabilityCheckResult checkElement(PsiElement element, Module usingModule) {
        AvailabilityCheckResult result = new AvailabilityCheckResult();
        if (element != null) {
            if (element instanceof PsiPackage) {
                PsiDirectory directory;
                PsiDirectory[] directories;
                PsiDirectory[] arr$ = directories = ((PsiPackage)element).getDirectories();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (result = this.checkDirectory(directory = arr$[i$], usingModule)).isOk(); ++i$) {
                }
            } else {
                PsiDirectory folder;
                PsiFile containingFile = element.getContainingFile();
                if (containingFile != null && (folder = containingFile.getContainingDirectory()) != null) {
                    result = this.checkDirectory(folder, usingModule);
                }
            }
        }
        AvailabilityCheckResult availabilityCheckResult = result;
        if (availabilityCheckResult == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassUnavailableInspection.checkElement must not return null");
        }
        return availabilityCheckResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private AvailabilityCheckResult checkDirectory(@NotNull PsiDirectory directory, @NotNull Module usingModule) {
        AvailabilityCheckResult availabilityCheckResult;
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.checkDirectory must not be null");
        }
        if (usingModule == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.checkDirectory must not be null");
        }
        BundleManager bundleManager = (BundleManager)ServiceManager.getService((Project)directory.getProject(), BundleManager.class);
        Module containingModule = ModuleUtil.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)usingModule.getProject());
        AvailabilityCheckResult result = new AvailabilityCheckResult(AvailabilityCheckResult.ResultType.SymbolIsNotExported, "No bundle provides this entity.");
        Collection<Object> usingModuleHostBundles = bundleManager.getHostBundles(usingModule);
        for (Object usingModuleHostBundle : usingModuleHostBundles) {
            if (usingModuleHostBundle != containingModule) continue;
            availabilityCheckResult = result;
            if (availabilityCheckResult == null) throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassUnavailableInspection.checkDirectory must not return null");
            return availabilityCheckResult;
        }
        Collection<Object> containingBundles = containingModule != null ? bundleManager.getHostBundles(containingModule) : new ArrayList<Object>();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)usingModule.getProject()).getFileIndex();
        List entriesForFile = projectFileIndex.getOrderEntriesForFile(directory.getVirtualFile());
        LibraryHandler libraryHandler = (LibraryHandler)ServiceManager.getService(LibraryHandler.class);
        for (OrderEntry orderEntry : entriesForFile) {
            Module orderEntryModule = orderEntry.getOwnerModule();
            if (orderEntryModule != usingModule) continue;
            if (orderEntry instanceof LibraryOrderEntry) {
                Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
                if (library == null || !(result = this.isLibraryExportingPackageTo(library, directory, usingModule, bundleManager)).isOk()) continue;
                break;
            }
            if (!(orderEntry instanceof ModuleOrderEntry)) continue;
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            if (containingModule != null) {
                Object containingBundleHost;
                result = this.isBundleExportingContainingPackageTo(module, containingModule, usingModule, directory, bundleManager);
                if (result.isOk()) continue;
                Iterator<Object> i$ = containingBundles.iterator();
                while (i$.hasNext() && !(result = this.isBundleExportingContainingPackageTo(containingBundleHost = i$.next(), containingBundleHost, usingModule, directory, bundleManager)).isOk()) {
                }
                continue;
            }
            ProjectSettings projectSettings = (ProjectSettings)ServiceManager.getService((Project)usingModule.getProject(), ProjectSettings.class);
            String frameworkInstanceName = projectSettings.getFrameworkInstanceName();
            if (frameworkInstanceName == null) continue;
            List<Library> libraries = libraryHandler.getLibraries(frameworkInstanceName);
            for (Library library : libraries) {
                VirtualFile[] files;
                for (VirtualFile file : files = library.getFiles(OrderRootType.CLASSES)) {
                    if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
                    result = this.isLibraryExportingPackageTo(library, directory, usingModule, bundleManager);
                }
            }
        }
        if ((availabilityCheckResult = result) != null) return availabilityCheckResult;
        throw new IllegalStateException("@NotNull method org/osmorc/inspection/ClassUnavailableInspection.checkDirectory must not return null");
    }

    private AvailabilityCheckResult isLibraryExportingPackageTo(Library library, PsiDirectory folder, Module usingModule, BundleManager bundleManager) {
        AvailabilityCheckResult result;
        block1: {
            Object bundleHost;
            result = this.isBundleExportingContainingPackageTo(library, library, usingModule, folder, bundleManager);
            if (result.isOk()) break block1;
            Collection<Object> hostBundles = bundleManager.getHostBundles(library);
            Iterator<Object> i$ = hostBundles.iterator();
            while (i$.hasNext() && !(result = this.isBundleExportingContainingPackageTo(bundleHost = i$.next(), bundleHost, usingModule, folder, bundleManager)).isOk()) {
            }
        }
        return result;
    }

    private AvailabilityCheckResult isBundleExportingContainingPackageTo(@NotNull Object exportingBundle, @NotNull Object containingBundle, @NotNull Object importingBundle, @NotNull PsiDirectory folder, @NotNull BundleManager bundleManager) {
        if (exportingBundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.isBundleExportingContainingPackageTo must not be null");
        }
        if (containingBundle == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.isBundleExportingContainingPackageTo must not be null");
        }
        if (importingBundle == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.isBundleExportingContainingPackageTo must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.isBundleExportingContainingPackageTo must not be null");
        }
        if (bundleManager == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.isBundleExportingContainingPackageTo must not be null");
        }
        PsiPackage containingPackage = JavaDirectoryService.getInstance().getPackage(folder);
        BundleDescription exporterDescription = bundleManager.getBundleDescription(exportingBundle);
        BundleDescription containerDescription = bundleManager.getBundleDescription(containingBundle);
        BundleDescription importerDescription = bundleManager.getBundleDescription(importingBundle);
        if (importerDescription != null && containingPackage != null) {
            if (containerDescription == null || this.isDirectImportExport(containingPackage, exporterDescription, importerDescription, bundleManager)) {
                return new AvailabilityCheckResult();
            }
            boolean containerExports = this.isContainerExportingPackage(containingPackage, containerDescription);
            boolean recursiveRequired = this.isRecursiveRequired(importerDescription, containerDescription, bundleManager);
            if (!containerExports) {
                return new AvailabilityCheckResult(AvailabilityCheckResult.ResultType.SymbolIsNotExported, "Bundle '" + bundleManager.getDisplayName(exportingBundle) + "' contains package '" + containingPackage.getQualifiedName() + "' but does not export it.");
            }
            if (!recursiveRequired) {
                return new AvailabilityCheckResult(AvailabilityCheckResult.ResultType.SymbolIsNotImported, "The package  '" + containingPackage.getQualifiedName() + "' is not imported in the manifest.");
            }
            return new AvailabilityCheckResult();
        }
        return new AvailabilityCheckResult();
    }

    private boolean isContainerExportingPackage(PsiPackage containingPackage, BundleDescription containerDescription) {
        ExportPackageDescription[] exportPackageDescriptions;
        boolean containerExportsPackage = false;
        for (ExportPackageDescription exportPackageDescription : exportPackageDescriptions = containerDescription.getExportPackages()) {
            if (!exportPackageDescription.getName().equals(containingPackage.getQualifiedName())) continue;
            containerExportsPackage = true;
            break;
        }
        return containerExportsPackage;
    }

    private boolean isDirectImportExport(PsiPackage containingPackage, BundleDescription exporterDescription, BundleDescription importerDescription, BundleManager bundleManager) {
        List<ExportPackageDescription> resolvedImports = bundleManager.getResolvedImports(importerDescription.getUserObject());
        for (ExportPackageDescription resolvedImport : resolvedImports) {
            if (!resolvedImport.getName().equals(containingPackage.getQualifiedName()) || resolvedImport.getExporter() != exporterDescription) continue;
            return true;
        }
        return false;
    }

    private boolean isRecursiveRequired(@NotNull BundleDescription requirer, @NotNull BundleDescription required, BundleManager bundleManager) {
        if (requirer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.isRecursiveRequired must not be null");
        }
        if (required == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/ClassUnavailableInspection.isRecursiveRequired must not be null");
        }
        List<BundleDescription> resolvedRequires = bundleManager.getResolvedRequires(requirer.getUserObject());
        for (BundleDescription resolvedRequire : resolvedRequires) {
            if (required != resolvedRequire) continue;
            return true;
        }
        for (BundleDescription resolvedRequire : resolvedRequires) {
            BundleSpecification[] requiredBundles;
            for (BundleSpecification requiredBundle : requiredBundles = resolvedRequire.getRequiredBundles()) {
                if (!requiredBundle.isExported()) continue;
                BundleDescription supplier = (BundleDescription)requiredBundle.getSupplier();
                if (supplier == required) {
                    return true;
                }
                if (supplier == null || !this.isRecursiveRequired(supplier, required, bundleManager)) continue;
                return true;
            }
        }
        return false;
    }
}

