/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.lang.ManifestTokenType;
import org.osmorc.manifest.lang.psi.Header;
import org.osmorc.manifest.lang.psi.ManifestFile;
import org.osmorc.manifest.lang.psi.Section;

public class MissingFinalNewlineInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("OSGi" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/MissingFinalNewlineInspection.getGroupDisplayName must not return null");
        }
        return "OSGi";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Missing Final New Line" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/MissingFinalNewlineInspection.getDisplayName must not return null");
        }
        return "Missing Final New Line";
    }

    @NotNull
    public String getShortName() {
        if ("osmorcMissingFinalNewline" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/MissingFinalNewlineInspection.getShortName must not return null");
        }
        return "osmorcMissingFinalNewline";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/MissingFinalNewlineInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Section section;
        String text;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/MissingFinalNewlineInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/MissingFinalNewlineInspection.checkFile must not be null");
        }
        if (file instanceof ManifestFile && (text = file.getText()).charAt(text.length() - 1) != '\n' && (section = (Section)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(text.length() - 1), Section.class, (boolean)false)) != null) {
            return new ProblemDescriptor[]{manager.createProblemDescriptor(section.getLastChild(), "Manifest file doesn't end with a final newline", (LocalQuickFix)new AddNewlineQuickFix(section), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
        }
        return new ProblemDescriptor[0];
    }

    private static class AddNewlineQuickFix
    implements LocalQuickFix {
        private final Section section;

        private AddNewlineQuickFix(Section section) {
            this.section = section;
        }

        @NotNull
        public String getName() {
            if ("Add newline" == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/MissingFinalNewlineInspection$AddNewlineQuickFix.getName must not return null");
            }
            return "Add newline";
        }

        @NotNull
        public String getFamilyName() {
            if ("Osmorc" == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/MissingFinalNewlineInspection$AddNewlineQuickFix.getFamilyName must not return null");
            }
            return "Osmorc";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/MissingFinalNewlineInspection$AddNewlineQuickFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/MissingFinalNewlineInspection$AddNewlineQuickFix.applyFix must not be null");
            }
            PsiElement lastChild = this.section.getLastChild();
            if (!(lastChild instanceof Header)) {
                throw new RuntimeException("No header found to add a newline to");
            }
            Header header = (Header)lastChild;
            header.getNode().addLeaf((IElementType)ManifestTokenType.NEWLINE, (CharSequence)"\n", null);
        }
    }
}

