/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.lang.headerparser.HeaderNameMatch;
import org.osmorc.manifest.lang.headerparser.HeaderParserRepository;
import org.osmorc.manifest.lang.psi.Header;

public class MisspelledHeaderNameInspection
extends LocalInspectionTool {
    private HeaderParserRepository _headerParserRepository;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("OSGi" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/MisspelledHeaderNameInspection.getGroupDisplayName must not return null");
        }
        return "OSGi";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/MisspelledHeaderNameInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unknown or Misspelled Header Name" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/MisspelledHeaderNameInspection.getDisplayName must not return null");
        }
        return "Unknown or Misspelled Header Name";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("osmorcMisspelledHeaderName" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/MisspelledHeaderNameInspection.getShortName must not return null");
        }
        return "osmorcMisspelledHeaderName";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/MisspelledHeaderNameInspection.buildVisitor must not be null");
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                Header header;
                String name;
                if (element instanceof Header && (name = (header = (Header)element).getName()) != null && name.length() > 0) {
                    ArrayList<HeaderNameSpellingQuickFix> quickFixes = new ArrayList<HeaderNameSpellingQuickFix>();
                    Collection<HeaderNameMatch> matches = MisspelledHeaderNameInspection.this.getHeaderParserRepository().getMatches(name);
                    for (HeaderNameMatch match : matches) {
                        quickFixes.add(new HeaderNameSpellingQuickFix(header, match));
                        if (quickFixes.size() <= 20) continue;
                        break;
                    }
                    if (quickFixes.size() > 0) {
                        holder.registerProblem((PsiElement)header.getNameToken(), "Header name is unknown or spelled incorrectly", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])quickFixes.toArray(new HeaderNameSpellingQuickFix[quickFixes.size()]));
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/MisspelledHeaderNameInspection.buildVisitor must not return null");
        }
        return psiElementVisitor;
    }

    HeaderParserRepository getHeaderParserRepository() {
        if (this._headerParserRepository == null) {
            this._headerParserRepository = (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);
        }
        return this._headerParserRepository;
    }

    private static class HeaderNameSpellingQuickFix
    implements LocalQuickFix {
        private final Header header;
        private final HeaderNameMatch match;

        private HeaderNameSpellingQuickFix(Header header, HeaderNameMatch match) {
            this.header = header;
            this.match = match;
        }

        @NotNull
        public String getName() {
            String string = String.format("Change to (%03d) \"%s\"", this.match.getDistance(), this.match.getProvider().getHeaderName());
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/MisspelledHeaderNameInspection$HeaderNameSpellingQuickFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Osmorc" == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/MisspelledHeaderNameInspection$HeaderNameSpellingQuickFix.getFamilyName must not return null");
            }
            return "Osmorc";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/MisspelledHeaderNameInspection$HeaderNameSpellingQuickFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/MisspelledHeaderNameInspection$HeaderNameSpellingQuickFix.applyFix must not be null");
            }
            this.header.setName(this.match.getProvider().getHeaderName());
        }
    }
}

