/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleActivator;
import org.osmorc.BundleManager;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.manifest.BundleManifest;
import org.osmorc.manifest.lang.ManifestTokenType;
import org.osmorc.manifest.lang.psi.Header;
import org.osmorc.manifest.lang.psi.Section;

public class UnregisteredActivatorInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("OSGi" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/UnregisteredActivatorInspection.getGroupDisplayName must not return null");
        }
        return "OSGi";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/UnregisteredActivatorInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Bundle Activator not registered" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/UnregisteredActivatorInspection.getDisplayName must not return null");
        }
        return "Bundle Activator not registered";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("osmorcUnregisteredActivator" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/UnregisteredActivatorInspection.getShortName must not return null");
        }
        return "osmorcUnregisteredActivator";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/UnregisteredActivatorInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitClass(PsiClass psiClass) {
                if (OsmorcFacet.hasOsmorcFacet((PsiElement)psiClass)) {
                    PsiClassType[] types;
                    for (PsiClassType type : types = psiClass.getSuperTypes()) {
                        if (!type.equalsToText(BundleActivator.class.getName())) continue;
                        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)OsmorcFacet.getInstance((PsiElement)psiClass).getConfiguration();
                        String activatorName = psiClass.getQualifiedName();
                        if (configuration.isManifestManuallyEdited()) {
                            Module module;
                            BundleManager bundleManager = (BundleManager)ServiceManager.getService((Project)psiClass.getProject(), BundleManager.class);
                            if (UnregisteredActivatorInspection.this.isActivatorRegistered(bundleManager, module = ModuleUtil.findModuleForPsiElement((PsiElement)psiClass), activatorName)) continue;
                            assert (activatorName != null);
                            holder.registerProblem((PsiElement)psiClass.getNameIdentifier(), "Bundle activator is not registered in manifest.", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RegisterActivatorInManifestQuickfix(activatorName, bundleManager.getBundleManifest(module).getManifestFile())});
                            continue;
                        }
                        String configuredActivator = configuration.getBundleActivator();
                        if (configuredActivator.equals(activatorName)) continue;
                        holder.registerProblem((PsiElement)psiClass.getNameIdentifier(), "Bundle activator is not set up in facet configuration.", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RegisterActivatorInConfigurationQuickfix(activatorName, configuration)});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/UnregisteredActivatorInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    private boolean isActivatorRegistered(BundleManager manager, Object bundle, String activatorName) {
        BundleManifest manifest = manager.getBundleManifest(bundle);
        if (manifest != null) {
            String manifestActivator = manifest.getBundleActivator();
            return manifestActivator != null && manifestActivator.equals(activatorName);
        }
        return true;
    }

    private class RegisterActivatorInConfigurationQuickfix
    implements LocalQuickFix {
        private static final String NAME = "Register Activator In Configuration";
        private static final String FAMILY = "Osmorc";
        private final String activatorClassName;
        private final OsmorcFacetConfiguration configuration;

        private RegisterActivatorInConfigurationQuickfix(@NotNull String activatorClassName, OsmorcFacetConfiguration configuration) {
            if (activatorClassName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInConfigurationQuickfix.<init> must not be null");
            }
            if (configuration == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInConfigurationQuickfix.<init> must not be null");
            }
            this.activatorClassName = activatorClassName;
            this.configuration = configuration;
        }

        @NotNull
        public String getName() {
            if (NAME == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInConfigurationQuickfix.getName must not return null");
            }
            return NAME;
        }

        @NotNull
        public String getFamilyName() {
            if (FAMILY == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInConfigurationQuickfix.getFamilyName must not return null");
            }
            return FAMILY;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInConfigurationQuickfix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInConfigurationQuickfix.applyFix must not be null");
            }
            this.configuration.setBundleActivator(this.activatorClassName);
        }
    }

    private class RegisterActivatorInManifestQuickfix
    implements LocalQuickFix {
        private static final String NAME = "Register Activator In Manifest";
        private static final String FAMILY = "Osmorc";
        private final String activatorClassName;
        private final PsiFile manifestFile;

        private RegisterActivatorInManifestQuickfix(@NotNull String activatorClassName, PsiFile manifestFile) {
            if (activatorClassName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInManifestQuickfix.<init> must not be null");
            }
            if (manifestFile == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInManifestQuickfix.<init> must not be null");
            }
            this.activatorClassName = activatorClassName;
            this.manifestFile = manifestFile;
        }

        @NotNull
        public String getName() {
            if (NAME == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInManifestQuickfix.getName must not return null");
            }
            return NAME;
        }

        @NotNull
        public String getFamilyName() {
            if (FAMILY == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInManifestQuickfix.getFamilyName must not return null");
            }
            return FAMILY;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInManifestQuickfix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/UnregisteredActivatorInspection$RegisterActivatorInManifestQuickfix.applyFix must not be null");
            }
            ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)this.manifestFile.getProject()).ensureFilesWritable(new VirtualFile[]{this.manifestFile.getVirtualFile()});
            if (!status.hasReadonlyFiles()) {
                Section mainSection = (Section)this.manifestFile.getFirstChild();
                Header activatorHeader = null;
                Header currentHeader = (Header)PsiTreeUtil.getChildOfType((PsiElement)mainSection, Header.class);
                while (activatorHeader == null && currentHeader != null) {
                    if ("Bundle-Activator".equalsIgnoreCase(currentHeader.getName())) {
                        activatorHeader = currentHeader;
                    }
                    currentHeader = (Header)PsiTreeUtil.getNextSiblingOfType((PsiElement)currentHeader, Header.class);
                }
                if (activatorHeader != null) {
                    this.replaceExistingActivatorHeader(activatorHeader);
                } else {
                    this.addActivatorHeader();
                }
            }
        }

        private void addActivatorHeader() {
            PsiFile fromText = PsiFileFactory.getInstance((Project)this.manifestFile.getProject()).createFileFromText("DUMMY.MF", String.format("Bundle-Activator: %s\n", this.activatorClassName));
            Header newheader = (Header)PsiTreeUtil.getChildOfType((PsiElement)fromText.getFirstChild(), Header.class);
            assert (newheader != null);
            Section section = (Section)this.manifestFile.getFirstChild();
            this.addMissiingNewline(section);
            section.add((PsiElement)newheader);
        }

        private void addMissiingNewline(Section section) {
            PsiElement lastChild;
            String sectionText = section.getText();
            if (sectionText.charAt(sectionText.length() - 1) != '\n' && (lastChild = section.getLastChild()) instanceof Header) {
                Header header = (Header)lastChild;
                header.getNode().addLeaf((IElementType)ManifestTokenType.NEWLINE, (CharSequence)"\n", null);
            }
        }

        private void replaceExistingActivatorHeader(Header activatorHeader) {
            String headerFormatString = "Bundle-Activator: %s\n";
            PsiFile fromText = PsiFileFactory.getInstance((Project)this.manifestFile.getProject()).createFileFromText("DUMMY.MF", String.format(headerFormatString, this.activatorClassName));
            Header newheader = (Header)PsiTreeUtil.getChildOfType((PsiElement)fromText.getFirstChild(), Header.class);
            assert (newheader != null);
            activatorHeader.replace((PsiElement)newheader);
        }
    }
}

