/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection.maven;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomRepository;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.frameworkintegration.CachingBundleInfoProvider;
import org.osmorc.obrimport.MavenRepository;
import org.osmorc.obrimport.ObrSearchDialog;
import org.osmorc.obrimport.springsource.ObrMavenResult;

public class NonOsgiMavenDependencyInspection
extends XmlSuppressableInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("OSGi" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection.getGroupDisplayName must not return null");
        }
        return "OSGi";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Non-OSGi dependency" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection.getDisplayName must not return null");
        }
        return "Non-OSGi dependency";
    }

    @NotNull
    public String getShortName() {
        if ("osmorcNonOsgiMavenDependency" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection.getShortName must not return null");
        }
        return "osmorcNonOsgiMavenDependency";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean b) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection.buildVisitor must not be null");
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag xmltag) {
                if (!OsmorcFacet.hasOsmorcFacet((PsiElement)xmltag)) {
                    return;
                }
                MavenDomDependency dependency = NonOsgiMavenDependencyInspection.getDependency(xmltag);
                if (dependency != null) {
                    String scope = dependency.getScope().getStringValue();
                    if ("test".equals(scope)) {
                        return;
                    }
                    MavenProjectsManager manager = MavenProjectsManager.getInstance((Project)xmltag.getProject());
                    File artifactFile = MavenArtifactUtil.getArtifactFile((File)manager.getLocalRepository(), (String)dependency.getGroupId().getStringValue(), (String)dependency.getArtifactId().getStringValue(), (String)dependency.getVersion().getStringValue(), (String)"jar");
                    if (artifactFile.exists()) {
                        try {
                            String url = artifactFile.toURL().toString();
                            if (!CachingBundleInfoProvider.isBundle(url)) {
                                problemsHolder.registerProblem((PsiElement)xmltag, "Dependency is not OSGi-ready", new LocalQuickFix[]{new FindOsgiCapableMavenDependencyQuickFix()});
                            }
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection.buildVisitor must not return null");
        }
        return xmlElementVisitor;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager inspectionManager, boolean b) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection.checkFile must not be null");
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection.checkFile must not be null");
        }
        if (!MavenDomUtil.isMavenFile((PsiFile)psiFile) || !OsmorcFacet.hasOsmorcFacet((PsiElement)psiFile)) {
            return new ProblemDescriptor[0];
        }
        return super.checkFile(psiFile, inspectionManager, b);
    }

    public static MavenDomDependency getDependency(XmlTag xmltag) {
        if (!"dependency".equals(xmltag.getName())) {
            return null;
        }
        DomElement dom = DomManager.getDomManager((Project)xmltag.getProject()).getDomElement(xmltag);
        if (dom != null) {
            return (MavenDomDependency)dom.getParentOfType(MavenDomDependency.class, false);
        }
        return null;
    }

    private static class FindOsgiCapableMavenDependencyQuickFix
    implements LocalQuickFix {
        private FindOsgiCapableMavenDependencyQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Osmorc" == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix.getFamilyName must not return null");
            }
            return "Osmorc";
        }

        @NotNull
        public String getName() {
            if ("Find OSGi-ready version" == null) {
                throw new IllegalStateException("@NotNull method org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix.getName must not return null");
            }
            return "Find OSGi-ready version";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix.applyFix must not be null");
            }
            if (problemDescriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/inspection/maven/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix.applyFix must not be null");
            }
            final MavenDomDependency dependency = NonOsgiMavenDependencyInspection.getDependency((XmlTag)problemDescriptor.getPsiElement());
            final ObrMavenResult mavenResult = ObrSearchDialog.queryForMavenArtifact(project, dependency.getArtifactId().toString());
            if (mavenResult != null) {
                final PsiFile psiFile = problemDescriptor.getPsiElement().getContainingFile();
                new WriteCommandAction(project, new PsiFile[]{psiFile}){

                    protected void run(Result result) throws Throwable {
                        MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel((Project)this.getProject(), (VirtualFile)psiFile.getVirtualFile());
                        MavenDomDependency dummy = model.getDependencies().addDependency();
                        dummy.getArtifactId().setStringValue(mavenResult.getArtifactId());
                        dummy.getVersion().setStringValue(mavenResult.getVersion());
                        dummy.getGroupId().setStringValue(mavenResult.getGroupId());
                        if (!"".equals(dependency.getScope().getStringValue())) {
                            dummy.getScope().setStringValue(dependency.getScope().getStringValue());
                        }
                        XmlElement newDep = dummy.getXmlElement();
                        XmlElement oldDep = dependency.getXmlElement();
                        oldDep.getParent().addAfter(newDep.copy(), (PsiElement)oldDep);
                        oldDep.delete();
                        newDep.delete();
                        MavenRepository[] repos = mavenResult.getBundleRepository().getMavenRepositories();
                        List repositories = model.getRepositories().getRepositories();
                        ArrayList<MavenRepository> knownRepositories = new ArrayList<MavenRepository>();
                        block0: for (MavenDomRepository repository : repositories) {
                            String knownRepoUrl = repository.getUrl().getStringValue();
                            for (MavenRepository repo : repos) {
                                if (!repo.getRepositoryUrl().equals(knownRepoUrl)) continue;
                                knownRepositories.add(repo);
                                continue block0;
                            }
                        }
                        ArrayList<MavenRepository> unknownRepositories = new ArrayList<MavenRepository>(Arrays.asList(repos));
                        unknownRepositories.removeAll(knownRepositories);
                        for (MavenRepository unknownRepository : unknownRepositories) {
                            MavenDomRepository repo = model.getRepositories().addRepository();
                            repo.getId().setStringValue(unknownRepository.getRepositoryId());
                            repo.getUrl().setStringValue(unknownRepository.getRepositoryUrl());
                            repo.getName().setStringValue(unknownRepository.getRepositoryDescription());
                        }
                    }
                }.execute();
                FileDocumentManager docManager = FileDocumentManager.getInstance();
                Document doc = docManager.getDocument(psiFile.getVirtualFile());
                docManager.saveDocument(doc);
                PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
            }
        }
    }
}

