/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.make;

import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Verifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.StacktraceUtil;
import org.osmorc.frameworkintegration.LibraryBundlificationRule;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.make.ReportingAnalyzer;
import org.osmorc.make.ReportingBuilder;
import org.osmorc.settings.ApplicationSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BndWrapper {
    @Nullable
    public String wrapLibrary(@NotNull CompileContext compileContext, String sourceJarUrl, String outputPath) {
        block8: {
            if (compileContext == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/make/BndWrapper.wrapLibrary must not be null");
            }
            try {
                File targetDir = new File(outputPath);
                File sourceFile = new File(VfsUtil.urlToPath((String)sourceJarUrl));
                if (sourceFile.isDirectory()) {
                    return null;
                }
                File targetFile = new File(targetDir.getPath() + File.separator + sourceFile.getName());
                HashMap<String, String> additionalProperties = new HashMap<String, String>();
                long lastModified = Long.MIN_VALUE;
                ApplicationSettings settings = (ApplicationSettings)ServiceManager.getService(ApplicationSettings.class);
                for (LibraryBundlificationRule bundlificationRule : settings.getLibraryBundlificationRules()) {
                    if (!bundlificationRule.appliesTo(sourceFile.getName())) continue;
                    if (bundlificationRule.isDoNotBundle()) {
                        return null;
                    }
                    additionalProperties.putAll(bundlificationRule.getAdditionalPropertiesMap());
                    lastModified = Math.max(lastModified, bundlificationRule.getLastModified());
                    if (!bundlificationRule.isStopAfterThisRule()) continue;
                    break;
                }
                if (!targetFile.exists() || targetFile.lastModified() < sourceFile.lastModified() || targetFile.lastModified() < lastModified) {
                    if (this.doWrap(compileContext, sourceFile, targetFile, additionalProperties)) {
                        return VfsUtil.pathToUrl((String)targetFile.getCanonicalPath());
                    }
                    break block8;
                }
                return VfsUtil.pathToUrl((String)targetFile.getCanonicalPath());
            }
            catch (Exception e) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, OsmorcBundle.getTranslation("bundlecompiler.bundlifying.problem.message", sourceJarUrl, StacktraceUtil.stackTraceToString(e)), null, 0, 0);
            }
        }
        return null;
    }

    private boolean doWrap(final @NotNull CompileContext compileContext, @NotNull File inputJar, final @NotNull File outputJar, @NotNull Map<String, String> properties) throws Exception {
        if (compileContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/make/BndWrapper.doWrap must not be null");
        }
        if (inputJar == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/make/BndWrapper.doWrap must not be null");
        }
        if (outputJar == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/make/BndWrapper.doWrap must not be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/osmorc/make/BndWrapper.doWrap must not be null");
        }
        String sourceFileUrl = VfsUtil.pathToUrl((String)inputJar.getPath());
        ReportingAnalyzer analyzer = new ReportingAnalyzer(compileContext, sourceFileUrl);
        analyzer.setPedantic(false);
        analyzer.setJar(inputJar);
        Jar dot = analyzer.getJar();
        analyzer.putAll(properties, false);
        if (analyzer.getProperty("Import-Package") == null) {
            analyzer.setProperty("Import-Package", "*;resolution:=optional");
        }
        if (analyzer.getProperty("Bundle-SymbolicName") == null) {
            String base;
            Pattern p = Pattern.compile("(" + Verifier.SYMBOLICNAME.pattern() + ")(-[0-9])?.*\\.jar");
            Matcher m = p.matcher(base = inputJar.getName());
            if (!m.matches()) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, "Can not calculate name of output bundle, rename jar or use -properties", sourceFileUrl, 0, 0);
                return false;
            }
            base = m.group(1);
            analyzer.setProperty("Bundle-SymbolicName", base);
        }
        if (analyzer.getProperty("Export-Package") == null) {
            analyzer.setProperty("Export-Package", "*");
        }
        analyzer.mergeManifest(dot.getManifest());
        String version = analyzer.getProperty("Bundle-Version");
        if (version != null) {
            version = Builder.cleanupVersion((String)version);
            analyzer.setProperty("Bundle-Version", version);
        }
        Manifest mf = analyzer.calcManifest();
        Jar jar = analyzer.getJar();
        final File f = File.createTempFile("tmpbnd", ".jar");
        jar.write(f);
        jar.close();
        analyzer.close();
        if (outputJar.exists() && !outputJar.delete()) {
            compileContext.addMessage(CompilerMessageCategory.ERROR, "Could not delete outdated generated bundle. Is " + outputJar.getPath() + " writable?", null, 0, 0);
            return false;
        }
        final Ref result = new Ref((Object)false);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            public void run() {
                result.set(ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        if (!f.renameTo(outputJar)) {
                            VirtualFile src = LocalFileSystem.getInstance().findFileByIoFile(f);
                            if (src == null) {
                                compileContext.addMessage(CompilerMessageCategory.ERROR, "No jar file was created. This should not happen. Is " + f.getPath() + " writable?", null, 0, 0);
                                return false;
                            }
                            File parentFolder = outputJar.getParentFile();
                            if (!parentFolder.exists() && !parentFolder.mkdirs()) {
                                compileContext.addMessage(CompilerMessageCategory.ERROR, "Cannot create output folder. Is " + parentFolder.getPath() + " writable?", null, 0, 0);
                                return false;
                            }
                            VirtualFile target = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFolder);
                            if (target == null) {
                                compileContext.addMessage(CompilerMessageCategory.ERROR, "Output path " + parentFolder.getPath() + " was created but cannot be found anymore. This should not happen.", null, 0, 0);
                                return false;
                            }
                            try {
                                VfsUtil.copyFile((Object)this, (VirtualFile)src, (VirtualFile)target, (String)outputJar.getName());
                            }
                            catch (IOException e) {
                                compileContext.addMessage(CompilerMessageCategory.ERROR, "Could not copy " + src + " to " + target, null, 0, 0);
                                return false;
                            }
                        }
                        return true;
                    }
                }));
            }
        }, ModalityState.defaultModalityState());
        return (Boolean)result.get();
    }

    public boolean build(@NotNull CompileContext compileContext, @NotNull String bndFileUrl, @NotNull String[] classPathUrls, @NotNull String outputPath, @NotNull Map<String, String> additionalProperties) {
        if (compileContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/make/BndWrapper.build must not be null");
        }
        if (bndFileUrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/make/BndWrapper.build must not be null");
        }
        if (classPathUrls == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/make/BndWrapper.build must not be null");
        }
        if (outputPath == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/osmorc/make/BndWrapper.build must not be null");
        }
        if (additionalProperties == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/osmorc/make/BndWrapper.build must not be null");
        }
        File[] classPathEntries = new File[classPathUrls.length];
        for (int i = 0; i < classPathUrls.length; ++i) {
            String classPathUrl = classPathUrls[i];
            classPathEntries[i] = new File(VfsUtil.urlToPath((String)classPathUrl));
        }
        File bndFile = new File(VfsUtil.urlToPath((String)bndFileUrl));
        File outFile = new File(outputPath);
        Properties props = new Properties();
        for (Map.Entry<String, String> stringStringEntry : additionalProperties.entrySet()) {
            props.put(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        try {
            return this.doBuild(compileContext, bndFile, classPathEntries, outFile, props);
        }
        catch (Exception e) {
            compileContext.addMessage(CompilerMessageCategory.ERROR, "Unexpected error: " + e.getMessage(), null, 0, 0);
            return false;
        }
    }

    private boolean doBuild(@NotNull CompileContext compileContext, @NotNull File bndFile, @NotNull File[] classpath, @NotNull File output, @NotNull Properties additionalProperties) throws Exception {
        File manifestFile;
        if (compileContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/make/BndWrapper.doBuild must not be null");
        }
        if (bndFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/make/BndWrapper.doBuild must not be null");
        }
        if (classpath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/make/BndWrapper.doBuild must not be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/osmorc/make/BndWrapper.doBuild must not be null");
        }
        if (additionalProperties == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/osmorc/make/BndWrapper.doBuild must not be null");
        }
        ReportingBuilder builder = new ReportingBuilder(compileContext, VfsUtil.pathToUrl((String)bndFile.getPath()));
        builder.setPedantic(false);
        builder.setProperties(bndFile);
        builder.mergeProperties(additionalProperties, true);
        if (builder.getProperty("Export-Package") == null) {
            builder.setProperty("Export-Package", "*");
        }
        builder.setClasspath(classpath);
        builder.begin();
        String manifest = builder.getProperty("-manifest");
        if (manifest != null && (manifestFile = builder.getFile(manifest)) != null && manifestFile.exists() && manifestFile.canRead()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(manifestFile));
                String value = props.getProperty(Attributes.Name.MANIFEST_VERSION.toString());
                if (value == null || value.length() == 0 || value.trim().length() == 0) {
                    compileContext.addMessage(CompilerMessageCategory.WARNING, "Your manifest does not contain a Manifest-Version entry. This will produce an empty manifest in the resulting bundle.", VfsUtil.pathToUrl((String)manifestFile.getAbsolutePath()), 0, 0);
                }
            }
            catch (Exception ex) {
                compileContext.addMessage(CompilerMessageCategory.INFORMATION, "There was a problem reading your manifest.", null, 0, 0);
            }
        }
        Jar jar = builder.build();
        jar.setName(output.getName());
        jar.write(output);
        builder.close();
        return true;
    }
}

