/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.make;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.PackagingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.make.BuildInstruction;
import com.intellij.openapi.compiler.make.BuildInstructionVisitor;
import com.intellij.openapi.compiler.make.BuildRecipe;
import com.intellij.openapi.compiler.make.FileCopyInstruction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.BundleManager;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.frameworkintegration.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.LibraryHandler;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.make.BndWrapper;
import org.osmorc.make.BundleProcessingItem;
import org.osmorc.make.BundleValidityState;
import org.osmorc.make.BundlorWrapper;
import org.osmorc.manifest.BundleManifest;

public class BundleCompiler
implements PackagingCompiler {
    private final Logger logger = Logger.getInstance((String)"#org.osmorc.make.BundleCompiler");

    @Nullable
    private static String getOutputPath(Module m, CompileContext context) {
        String path;
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)m);
        VirtualFile moduleCompilerOutputPath = extension.getCompilerOutputPath();
        if (moduleCompilerOutputPath == null) {
            String outputPathUrl = extension.getCompilerOutputUrl();
            File f = new File(VfsUtil.urlToPath((String)outputPathUrl));
            if (!f.exists() && !f.mkdirs()) {
                context.addMessage(CompilerMessageCategory.ERROR, OsmorcBundle.getTranslation("faceteditor.cannot.create.outputpath", new Object[0]), null, 0, 0);
                return null;
            }
            path = f.getParentFile().getPath() + File.separator + "bundles";
        } else {
            path = moduleCompilerOutputPath.getParent().getPath() + File.separator + "bundles";
        }
        File f = new File(path);
        if (!f.exists() && !f.mkdirs()) {
            context.addMessage(CompilerMessageCategory.ERROR, "Could not create output path: " + path + " Please check file permissions.", null, 0, 0);
            return null;
        }
        return path;
    }

    public void processOutdatedItem(CompileContext compileContext, String s, final @Nullable ValidityState validityState) {
        if (validityState != null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                public void run() {
                    BundleValidityState myvalstate = (BundleValidityState)validityState;
                    String jarUrl = myvalstate.getOutputJarUrl();
                    if (jarUrl != null) {
                        FileUtil.delete((File)new File(jarUrl));
                    }
                }
            });
        }
    }

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext compileContext) {
        FileProcessingCompiler.ProcessingItem[] processingItemArray = (FileProcessingCompiler.ProcessingItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<FileProcessingCompiler.ProcessingItem[]>(){

            public FileProcessingCompiler.ProcessingItem[] compute() {
                CompileScope compilescope = compileContext.getCompileScope();
                Module[] affectedModules = compilescope.getAffectedModules();
                if (affectedModules.length == 0) {
                    return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
                }
                Project project = affectedModules[0].getProject();
                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                THashSet thashset = new THashSet();
                for (Module module : modules) {
                    if (!OsmorcFacet.hasOsmorcFacet(module)) continue;
                    thashset.add((Object)module);
                }
                FileProcessingCompiler.ProcessingItem[] result = new FileProcessingCompiler.ProcessingItem[thashset.size()];
                int i = 0;
                for (Module aThashset : thashset) {
                    Module module = aThashset;
                    if (module.getModuleFile() == null) continue;
                    result[i++] = new BundleProcessingItem(module);
                }
                return result;
            }
        });
        if (processingItemArray == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/make/BundleCompiler.getProcessingItems must not return null");
        }
        return processingItemArray;
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext compileContext, FileProcessingCompiler.ProcessingItem[] processingItems) {
        try {
            for (FileProcessingCompiler.ProcessingItem processingItem : processingItems) {
                Module module = ((BundleProcessingItem)processingItem).getModule();
                BundleCompiler.buildBundle(module, compileContext.getProgressIndicator(), compileContext);
            }
        }
        catch (IOException ioexception) {
            this.logger.error((Throwable)ioexception);
        }
        return processingItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildBundle(final Module module, ProgressIndicator progressIndicator, CompileContext compileContext) throws IOException {
        File jarFile = new File(VfsUtil.urlToPath((String)BundleCompiler.getJarFileName(module)));
        if (jarFile.exists()) {
            jarFile.delete();
        }
        FileUtil.createParentDirs((File)jarFile);
        BuildRecipe buildrecipe = (BuildRecipe)new ReadAction<BuildRecipe>(){

            protected void run(Result<BuildRecipe> result) {
                result.setResult((Object)BundleCompiler.getBuildRecipe(module));
            }
        }.execute().getResultObject();
        BndWrapper wrapper = new BndWrapper();
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)OsmorcFacet.getInstance(module).getConfiguration();
        final ArrayList classPaths = new ArrayList();
        try {
            buildrecipe.visitInstructionsWithExceptions(new BuildInstructionVisitor(){

                public boolean visitInstruction(BuildInstruction buildinstruction) throws IOException {
                    ProgressManager.checkCanceled();
                    if (buildinstruction instanceof FileCopyInstruction) {
                        FileCopyInstruction filecopyinstruction = (FileCopyInstruction)buildinstruction;
                        File file2 = filecopyinstruction.getFile();
                        if (file2 == null || !file2.exists()) {
                            return true;
                        }
                        String s2 = FileUtil.toSystemDependentName((String)file2.getPath());
                        classPaths.add(VfsUtil.pathToUrl((String)s2));
                    }
                    return true;
                }
            }, false);
        }
        catch (ProcessCanceledException e) {
            compileContext.addMessage(CompilerMessageCategory.INFORMATION, "Process canceled.", null, 0, 0);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String bndFileUrl = "";
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        if (configuration.isOsmorcControlsManifest() || configuration.isUseBndFile() || configuration.isUseBundlorFile()) {
            if (configuration.isUseBndFile()) {
                File bndFile = BundleCompiler.findFileInModuleContentRoots(configuration.getBndFileLocation(), module);
                if (bndFile == null || !bndFile.exists()) {
                    compileContext.addMessage(CompilerMessageCategory.ERROR, String.format("The bnd file \"%s\" for module \"%s\" does not exist.", configuration.getBndFileLocation(), module.getName()), configuration.getBndFileLocation(), 0, 0);
                    return;
                }
                bndFileUrl = VfsUtil.pathToUrl((String)bndFile.getPath());
            } else if (configuration.isUseBundlorFile() ? (bndFileUrl = BundleCompiler.makeBndFile(module, "", compileContext)) == null : (bndFileUrl = BundleCompiler.makeBndFile(module, configuration.asManifestString(), compileContext)) == null) {
                return;
            }
        } else {
            String manifestFilePath;
            PsiFile manifestFile;
            boolean manifestExists = false;
            BundleManager bundleManager = (BundleManager)ServiceManager.getService((Project)module.getProject(), BundleManager.class);
            BundleManifest bundleManifest = bundleManager.getBundleManifest(module);
            if (bundleManifest != null && (manifestFile = bundleManifest.getManifestFile()) != null && (manifestFilePath = manifestFile.getVirtualFile().getPath()) != null) {
                bndFileUrl = BundleCompiler.makeBndFile(module, "-manifest " + manifestFilePath + "\n", compileContext);
                manifestExists = true;
            }
            if (!manifestExists) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, "Manifest file for module " + module.getName() + ": '" + OsmorcFacet.getInstance(module).getManifestLocation() + "' does not exist or cannot be found. Check that file exists and is not excluded from the module.", null, 0, 0);
                return;
            }
        }
        if (!configuration.isOsmorcControlsManifest() || configuration.isOsmorcControlsManifest() && !configuration.isUseBndFile() && !configuration.isUseBundlorFile()) {
            StringBuilder pathBuilder = new StringBuilder();
            for (int i = 0; i < classPaths.size(); ++i) {
                String classPath = (String)classPaths.get(i);
                String relPath = FileUtil.getRelativePath((File)new File(VfsUtil.urlToPath((String)bndFileUrl)), (File)new File(VfsUtil.urlToPath((String)classPath)));
                if (i != 0) {
                    pathBuilder.append(",");
                }
                pathBuilder.append(relPath);
            }
            List<Pair<String, String>> list = configuration.getAdditionalJARContents();
            for (Pair<String, String> stringStringPair : list) {
                pathBuilder.append(",").append((String)stringStringPair.second).append(" = ").append((String)stringStringPair.first);
            }
            additionalProperties.put("Include-Resource", pathBuilder.toString());
            if (!configuration.isIgnorePatternValid()) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, "The file ignore pattern in the facet configuration is invalid.", null, 0, 0);
                return;
            }
            if (!"".equals(configuration.getIgnoreFilePattern())) {
                additionalProperties.put("-donotcopy", configuration.getIgnoreFilePattern());
            }
        }
        String outputPath = jarFile.getPath();
        if (configuration.isUseBundlorFile()) {
            outputPath = outputPath + ".tmp.jar";
        }
        wrapper.build(compileContext, bndFileUrl, ArrayUtil.toStringArray(classPaths), outputPath, additionalProperties);
        if (configuration.isUseBundlorFile()) {
            File bundlorFile = BundleCompiler.findFileInModuleContentRoots(configuration.getBundlorFileLocation(), module);
            if (bundlorFile == null || !bundlorFile.exists()) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, String.format("The Bundlor file \"%s\" for module \"%s\" does not exist.", configuration.getBundlorFileLocation(), module.getName()), configuration.getBundlorFileLocation(), 0, 0);
                return;
            }
            BundlorWrapper bw = new BundlorWrapper();
            try {
                if (!bw.wrapModule(compileContext, outputPath, jarFile.getPath(), bundlorFile.getPath())) {
                    compileContext.addMessage(CompilerMessageCategory.ERROR, "Bundlifying the file " + jarFile.getPath() + " with Bundlor failed.", null, 0, 0);
                    return;
                }
            }
            finally {
                File tempJar = new File(outputPath);
                if (tempJar.exists() && !tempJar.delete()) {
                    compileContext.addMessage(CompilerMessageCategory.WARNING, "Could not delete temporary file: " + tempJar.getPath(), null, 0, 0);
                }
            }
        }
        if (!configuration.isUseBndFile() && !configuration.isUseBundlorFile()) {
            BundleCompiler.bundlifyLibraries(module, progressIndicator, compileContext);
        }
    }

    @Nullable
    private static String makeBndFile(Module module, String contents, CompileContext compileContext) throws IOException {
        String outputPath = BundleCompiler.getOutputPath(module, compileContext);
        if (outputPath == null) {
            return null;
        }
        File tmpFile = File.createTempFile("osmorc", ".bnd", new File(outputPath));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
        bos.write(contents.getBytes());
        bos.close();
        tmpFile.deleteOnExit();
        return VfsUtil.pathToUrl((String)tmpFile.getPath());
    }

    @Nullable
    protected static File findFileInModuleContentRoots(String file, Module module) {
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : manager.getContentRoots()) {
            VirtualFile result = VfsUtil.findRelativeFile((String)file, (VirtualFile)root);
            if (result == null) continue;
            return new File(result.getPath());
        }
        return null;
    }

    @Nullable
    public static VirtualFile getManifestFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/make/BundleCompiler.getManifestFile must not be null");
        }
        OsmorcFacet facet = OsmorcFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : manager.getContentRoots()) {
            VirtualFile result = VfsUtil.findRelativeFile((String)facet.getManifestLocation(), (VirtualFile)root);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @NotNull
    public String getDescription() {
        if ("bundle compile" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/make/BundleCompiler.getDescription must not return null");
        }
        return "bundle compile";
    }

    public boolean validateConfiguration(CompileScope compileScope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new BundleValidityState(in);
    }

    static BuildRecipe getBuildRecipe(Module module) {
        BuildRecipe buildrecipe = DeploymentUtil.getInstance().createBuildRecipe();
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension != null) {
            String url = extension.getCompilerOutputUrl();
            File root = new File(FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)url)));
            buildrecipe.addFileCopyInstruction(root, true, "");
        }
        return buildrecipe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] bundlifyLibraries(Module module, ProgressIndicator indicator, @NotNull CompileContext compileContext) {
        if (compileContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/make/BundleCompiler.bundlifyLibraries must not be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        final ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        LibraryHandler libraryHandler = (LibraryHandler)ServiceManager.getService(LibraryHandler.class);
        ModifiableRootModel model = (ModifiableRootModel)new ReadAction<ModifiableRootModel>(){

            protected void run(Result<ModifiableRootModel> result) throws Throwable {
                ModifiableRootModel model = manager.getModifiableModel();
                result.setResult((Object)model);
            }
        }.execute().getResultObject();
        OrderEntry[] entries = model.getOrderEntries();
        try {
            block3: for (OrderEntry entry : entries) {
                String[] urls;
                if (entry instanceof JdkOrderEntry || entry instanceof LibraryOrderEntry && libraryHandler.isFrameworkInstanceLibrary((LibraryOrderEntry)entry)) continue;
                BndWrapper wrapper = new BndWrapper();
                for (String url : urls = entry.getUrls(OrderRootType.CLASSES)) {
                    if (CachingBundleInfoProvider.canBeBundlified(url = BundleCompiler.convertJarUrlToFileUrl(url))) {
                        indicator.setText("Bundling non-OSGi libraries for module: " + module.getName());
                        indicator.setText2(url);
                        String outputPath = BundleCompiler.getOutputPath(module, compileContext);
                        if (outputPath == null) continue block3;
                        String bundledLocation = wrapper.wrapLibrary(compileContext, url, outputPath);
                        if (bundledLocation == null) continue;
                        result.add(BundleCompiler.fixFileURL(bundledLocation));
                        continue;
                    }
                    if (!CachingBundleInfoProvider.isBundle(url)) continue;
                    result.add(BundleCompiler.fixFileURL(url));
                }
            }
            String[] stringArray = ArrayUtil.toStringArray(result);
            return stringArray;
        }
        finally {
            model.dispose();
        }
    }

    public static String convertJarUrlToFileUrl(String url) {
        url = url.replaceAll("!.*", "");
        url = url.replace("jar://", "file://");
        return url;
    }

    public static String fixFileURL(String url) {
        return url.startsWith("file:///") ? url : url.replace("file://", "file:///");
    }

    @Nullable
    public static String getJarFileName(Module module) {
        OsmorcFacet facet = OsmorcFacet.getInstance(module);
        if (facet != null) {
            return ((OsmorcFacetConfiguration)facet.getConfiguration()).getJarFileLocation();
        }
        return null;
    }
}

