/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.make;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.make.BuildInstructionVisitor;
import com.intellij.openapi.compiler.make.BuildRecipe;
import com.intellij.openapi.compiler.make.FileCopyInstruction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.TObjectLongHashMap;
import gnu.trove.TObjectLongProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.frameworkintegration.LibraryBundlificationRule;
import org.osmorc.make.BundleCompiler;
import org.osmorc.settings.ApplicationSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleValidityState
implements ValidityState {
    private final String moduleName;
    private final String[] fileUrls;
    private final long[] fileTimestamps;
    private final String jarUrl;
    private final long jarLastModificationTime;
    private final boolean alwaysRebuildBundleJAR;
    private final long rulesModifiedTimeStamp;

    public BundleValidityState(final Module module) {
        this.moduleName = module.getName();
        this.jarUrl = BundleCompiler.getJarFileName(module);
        OsmorcFacet osmorcFacet = OsmorcFacet.getInstance(module);
        boolean bl = this.alwaysRebuildBundleJAR = OsmorcFacet.hasOsmorcFacet(module) && ((OsmorcFacetConfiguration)osmorcFacet.getConfiguration()).isAlwaysRebuildBundleJAR();
        if (this.alwaysRebuildBundleJAR) {
            this.jarLastModificationTime = 0L;
            this.fileTimestamps = new long[0];
            this.fileUrls = ArrayUtil.EMPTY_STRING_ARRAY;
        } else {
            this.jarLastModificationTime = new File(VfsUtil.urlToPath((String)this.jarUrl)).lastModified();
            final TObjectLongHashMap url2Timestamps = new TObjectLongHashMap();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                public void run() {
                    BuildRecipe buildrecipe = BundleCompiler.getBuildRecipe(module);
                    buildrecipe.visitInstructions(new BuildInstructionVisitor(){

                        public boolean visitFileCopyInstruction(FileCopyInstruction filecopyinstruction) throws Exception {
                            File file = filecopyinstruction.getFile();
                            VirtualFile virtualfile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)file.getPath()));
                            if (virtualfile != null) {
                                BundleValidityState.registerTimestamps(virtualfile, (TObjectLongHashMap<String>)url2Timestamps);
                            }
                            return true;
                        }
                    }, false);
                }
            });
            VirtualFile manifestFile = BundleCompiler.getManifestFile(module);
            if (manifestFile != null) {
                BundleValidityState.registerTimestamps(manifestFile, (TObjectLongHashMap<String>)url2Timestamps);
            }
            if (osmorcFacet != null) {
                OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
                List<Pair<String, String>> jarContents = configuration.getAdditionalJARContents();
                for (Pair<String, String> jarContent : jarContents) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath((String)jarContent.getFirst());
                    if (file == null) continue;
                    BundleValidityState.registerTimestamps(file, (TObjectLongHashMap<String>)url2Timestamps);
                }
                if (configuration.isUseBndFile()) {
                    String bndFileLocation = configuration.getBndFileLocation();
                    VirtualFile bndFile = LocalFileSystem.getInstance().findFileByIoFile(BundleCompiler.findFileInModuleContentRoots(bndFileLocation, module));
                    if (bndFile != null && bndFile.exists()) {
                        BundleValidityState.registerTimestamps(bndFile, (TObjectLongHashMap<String>)url2Timestamps);
                        this.registerDependencies(bndFile, (TObjectLongHashMap<String>)url2Timestamps);
                    }
                }
            }
            this.fileUrls = new String[url2Timestamps.size()];
            this.fileTimestamps = new long[url2Timestamps.size()];
            TObjectLongProcedure<String> tobjectlongprocedure = new TObjectLongProcedure<String>(){
                int i;

                public boolean execute(String s, long l) {
                    ((BundleValidityState)BundleValidityState.this).fileUrls[this.i] = s;
                    ((BundleValidityState)BundleValidityState.this).fileTimestamps[this.i] = l;
                    ++this.i;
                    return true;
                }
            };
            url2Timestamps.forEachEntry((TObjectLongProcedure)tobjectlongprocedure);
        }
        long lastModified = 0L;
        ApplicationSettings settings = (ApplicationSettings)ServiceManager.getService(ApplicationSettings.class);
        for (LibraryBundlificationRule bundlificationRule : settings.getLibraryBundlificationRules()) {
            lastModified = Math.max(lastModified, bundlificationRule.getLastModified());
        }
        this.rulesModifiedTimeStamp = lastModified;
    }

    private void registerDependencies(VirtualFile bndFile, TObjectLongHashMap<String> url2Timestamps) {
        try {
            String contents = VfsUtil.loadText((VirtualFile)bndFile);
            Pattern p = Pattern.compile("-include[:=\\s](.+)");
            Matcher m = p.matcher(contents);
            while (m.find()) {
                String[] listMembers;
                String dependentFileLocation = m.group(1);
                for (String listMember : listMembers = dependentFileLocation.split(",")) {
                    VirtualFile dependentFile = VfsUtil.findRelativeFile((String)(listMember = listMember.trim().replaceFirst("^[~-]", "")), (VirtualFile)bndFile);
                    if (dependentFile == null || !dependentFile.exists()) continue;
                    if (url2Timestamps.containsKey((Object)dependentFile.getUrl())) {
                        return;
                    }
                    BundleValidityState.registerTimestamps(dependentFile, url2Timestamps);
                    this.registerDependencies(dependentFile, url2Timestamps);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BundleValidityState(DataInput in) throws IOException {
        this.alwaysRebuildBundleJAR = in.readBoolean();
        this.moduleName = IOUtil.readString((DataInput)in);
        int i = in.readInt();
        this.fileUrls = new String[i];
        this.fileTimestamps = new long[i];
        for (int j = 0; j < i; ++j) {
            String s = IOUtil.readString((DataInput)in);
            long l = in.readLong();
            this.fileUrls[j] = s;
            this.fileTimestamps[j] = l;
        }
        this.jarUrl = IOUtil.readString((DataInput)in);
        this.jarLastModificationTime = in.readLong();
        this.rulesModifiedTimeStamp = in.readLong();
    }

    public void save(DataOutput out) throws IOException {
        out.writeBoolean(this.alwaysRebuildBundleJAR);
        IOUtil.writeString((String)this.moduleName, (DataOutput)out);
        int i = this.fileUrls.length;
        out.writeInt(i);
        for (int j = 0; j < i; ++j) {
            String s = this.fileUrls[j];
            long l = this.fileTimestamps[j];
            IOUtil.writeString((String)s, (DataOutput)out);
            out.writeLong(l);
        }
        IOUtil.writeString((String)this.jarUrl, (DataOutput)out);
        out.writeLong(this.jarLastModificationTime);
        out.writeLong(this.rulesModifiedTimeStamp);
    }

    public String getOutputJarUrl() {
        return this.jarUrl;
    }

    public boolean equalsTo(ValidityState validitystate) {
        if (this.alwaysRebuildBundleJAR) {
            return false;
        }
        if (!(validitystate instanceof BundleValidityState)) {
            return false;
        }
        BundleValidityState myvalstate = (BundleValidityState)validitystate;
        if (this.rulesModifiedTimeStamp != myvalstate.rulesModifiedTimeStamp) {
            return false;
        }
        if (!this.moduleName.equals(myvalstate.moduleName)) {
            return false;
        }
        if (this.fileUrls.length != myvalstate.fileUrls.length) {
            return false;
        }
        for (int i = 0; i < this.fileUrls.length; ++i) {
            String s = this.fileUrls[i];
            long l = this.fileTimestamps[i];
            if (s.equals(myvalstate.fileUrls[i]) && l == myvalstate.fileTimestamps[i]) continue;
            return false;
        }
        return Comparing.strEqual((String)this.jarUrl, (String)myvalstate.jarUrl) && this.jarLastModificationTime == myvalstate.jarLastModificationTime;
    }

    private static void registerTimestamps(VirtualFile virtualfile, TObjectLongHashMap<String> url2Timestamps) {
        if (virtualfile.isDirectory()) {
            VirtualFile[] avirtualfile1;
            for (VirtualFile virtualfile1 : avirtualfile1 = virtualfile.getChildren()) {
                BundleValidityState.registerTimestamps(virtualfile1, url2Timestamps);
            }
        } else {
            url2Timestamps.put((Object)virtualfile.getUrl(), virtualfile.getTimeStamp());
        }
    }
}

