/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.make;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.make.ViewManifestAction;

public class ViewGeneratedManifestGroup
extends ActionGroup {
    private static final AnAction[] EMPTY_ACTIONS_LIST = new AnAction[0];

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Module[] modules;
        AnAction[] anActionArray;
        if (e == null) {
            anActionArray = EMPTY_ACTIONS_LIST;
            if (EMPTY_ACTIONS_LIST == null) throw new IllegalStateException("@NotNull method org/osmorc/make/ViewGeneratedManifestGroup.getChildren must not return null");
            return anActionArray;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            anActionArray = EMPTY_ACTIONS_LIST;
            if (EMPTY_ACTIONS_LIST == null) throw new IllegalStateException("@NotNull method org/osmorc/make/ViewGeneratedManifestGroup.getChildren must not return null");
            return anActionArray;
        }
        ArrayList<ViewManifestAction> actions = new ArrayList<ViewManifestAction>();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            OsmorcFacet facet;
            if (!OsmorcFacet.hasOsmorcFacet(module) || (facet = OsmorcFacet.getInstance(module)) == null) continue;
            String jarFile = ((OsmorcFacetConfiguration)facet.getConfiguration()).getJarFileLocation();
            File theFile = new File(jarFile);
            String fileName = "[" + module.getName() + "] " + jarFile.substring(jarFile.lastIndexOf(47) + 1);
            ViewManifestAction action = new ViewManifestAction(fileName, jarFile);
            actions.add(action);
        }
        anActionArray = actions.toArray(new AnAction[actions.size()]);
        if (anActionArray != null) return anActionArray;
        throw new IllegalStateException("@NotNull method org/osmorc/make/ViewGeneratedManifestGroup.getChildren must not return null");
    }
}

