/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.make;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;

public class ViewManifestAction
extends AnAction
implements DumbAware {
    private String pathToJar;

    public ViewManifestAction(String title, String pathToJar) {
        this.pathToJar = pathToJar;
        this.getTemplatePresentation().setText(title);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        VirtualFile jarFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.pathToJar);
        if (jarFile == null) {
            Messages.showErrorDialog((Project)project, (String)"It seems that the bundle JAR does not exist. Please rebuild the project and try again.", (String)"Cannot open manifest");
            return;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
        if (jarRoot != null) {
            VirtualFile manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
            if (manifestFile == null) {
                Messages.showErrorDialog((Project)project, (String)"There is no manifest in the bundle jar. Please check the facet settings, rebuild and try again.", (String)"Cannot open manifest");
                return;
            }
            FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
            if (editorProviderManager.getProviders(project, manifestFile).length == 0) {
                Messages.showMessageDialog((Project)project, (String)IdeBundle.message((String)"error.files.of.this.type.cannot.be.opened", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), (String)IdeBundle.message((String)"title.cannot.open.file", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return;
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, manifestFile);
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
    }
}

