/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.BundleManifest;
import org.osmorc.manifest.lang.psi.Clause;
import org.osmorc.manifest.lang.psi.Header;
import org.osmorc.manifest.lang.psi.HeaderValuePart;
import org.osmorc.manifest.lang.psi.ManifestFile;
import org.osmorc.valueobject.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManifestImpl
implements BundleManifest {
    private static final String REQUIRE_BUNDLE = "Require-Bundle";
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String BUNDLE_ACTIVATION_POLICY = "Bundle-ActivationPolicy";
    private static final String BUNDLE_ACTIVATOR = "Bundle-Activator";
    private static final String BUNDLE_CATEGORY = "Bundle-Category";
    private static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    private static final String BUNDLE_CONTACT_ADDRESS = "Bundle-ContactAddress";
    private static final String BUNDLE_COPYRIGHT = "Bundle-Copyright";
    private static final String BUNDLE_DESCRIPTION = "Bundle-Description";
    private static final String BUNDLE_DOC_URL = "Bundle-DocURL";
    private static final String BUNDLE_LOCALIZATION = "Bundle-Localization";
    private static final String BUNDLE_MANIFEST_VERSION = "Bundle-ManifestVersion";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_NATIVE_CODE = "Bundle-NativeCode";
    private static final String BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String BUNDLE_UPDATE_LOCATION = "Bundle-UpdateLocation";
    private static final String BUNDLE_VENDOR = "Bundle-Vendor";
    private static final String DYNAMIC_IMPORT_PACKAGE = "DynamicImport-Package";
    private static final String FRAGMENT_HOST = "Fragment-Host";
    private final PsiFile _manifestFile;

    public BundleManifestImpl(PsiFile manifestFile) {
        this._manifestFile = manifestFile;
    }

    @Override
    public PsiFile getManifestFile() {
        return this._manifestFile;
    }

    @Override
    public Version getBundleVersion() {
        return (Version)this.getHeaderValue(BUNDLE_VERSION);
    }

    @Override
    public String getBundleSymbolicName() {
        return (String)this.getHeaderValue(BUNDLE_SYMBOLIC_NAME);
    }

    @Override
    public String getBundleActivator() {
        return (String)this.getHeaderValue(BUNDLE_ACTIVATOR);
    }

    @Override
    public List<String> getExportPackage() {
        return this.getAllPaths(EXPORT_PACKAGE);
    }

    @Override
    public List<PsiPackage> getImportPackage() {
        List<PsiReference> allPathReferences = this.getAllPathReferences(IMPORT_PACKAGE);
        ArrayList<PsiPackage> importedPackages = new ArrayList<PsiPackage>();
        for (PsiReference pathReference : allPathReferences) {
            PsiPackage psiPackage = (PsiPackage)pathReference.resolve();
            if (psiPackage == null) continue;
            importedPackages.add(psiPackage);
        }
        return importedPackages;
    }

    @Override
    public List<Module> getRequireBundle() {
        List<PsiReference> allPathReferences = this.getAllPathReferences(REQUIRE_BUNDLE);
        ArrayList<Module> requiredBundles = new ArrayList<Module>();
        for (PsiReference pathReference : allPathReferences) {
            ManifestFile manifestFile = (ManifestFile)pathReference.resolve();
            if (manifestFile == null) continue;
            requiredBundles.add(ModuleUtil.findModuleForPsiElement((PsiElement)manifestFile));
        }
        return requiredBundles;
    }

    @Override
    public boolean exportsPackage(@NotNull String aPackage) {
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/impl/BundleManifestImpl.exportsPackage must not be null");
        }
        return this.getExportPackage().contains(aPackage);
    }

    private List<String> getAllPaths(@NotNull String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/impl/BundleManifestImpl.getAllPaths must not be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        Header header = this.findHeader(headerName);
        if (header != null) {
            List<Clause> clauses = this.findAllChildrenOfType((PsiElement)header, Clause.class);
            for (Clause clause : clauses) {
                List<HeaderValuePart> headerValues = this.findAllChildrenOfType(clause, HeaderValuePart.class);
                for (HeaderValuePart headerValue : headerValues) {
                    String value = headerValue.getUnwrappedText();
                    if (result.contains(value)) continue;
                    result.add(value);
                }
            }
        }
        return result;
    }

    private List<PsiReference> getAllPathReferences(@NotNull String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/impl/BundleManifestImpl.getAllPathReferences must not be null");
        }
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        Header header = this.findHeader(headerName);
        if (header != null) {
            List<Clause> clauses = this.findAllChildrenOfType((PsiElement)header, Clause.class);
            for (Clause clause : clauses) {
                List<HeaderValuePart> headerValues = this.findAllChildrenOfType(clause, HeaderValuePart.class);
                for (HeaderValuePart headerValue : headerValues) {
                    PsiReference value = headerValue.getReference();
                    if (result.contains(value)) continue;
                    result.add(value);
                }
            }
        }
        return result;
    }

    private Object getHeaderValue(@NotNull String headerName) {
        Clause clause;
        if (headerName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/impl/BundleManifestImpl.getHeaderValue must not be null");
        }
        Header header = this.findHeader(headerName);
        HeaderValuePart value = null;
        if (header != null && (clause = (Clause)PsiTreeUtil.getChildOfType((PsiElement)header, Clause.class)) != null) {
            value = (HeaderValuePart)PsiTreeUtil.getChildOfType((PsiElement)clause, HeaderValuePart.class);
        }
        return value != null ? value.getConvertedValue() : null;
    }

    private Header findHeader(@NotNull String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/impl/BundleManifestImpl.findHeader must not be null");
        }
        Header header = (Header)PsiTreeUtil.getChildOfType((PsiElement)this._manifestFile.getFirstChild(), Header.class);
        while (header != null && !headerName.equalsIgnoreCase(header.getName())) {
            header = (Header)PsiTreeUtil.getNextSiblingOfType((PsiElement)header, Header.class);
        }
        return header;
    }

    private <T extends PsiElement> List<T> findAllChildrenOfType(@NotNull PsiElement element, @NotNull Class<T> elementClass) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/impl/BundleManifestImpl.findAllChildrenOfType must not be null");
        }
        if (elementClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/manifest/impl/BundleManifestImpl.findAllChildrenOfType must not be null");
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PsiElement currentElement = PsiTreeUtil.getChildOfType((PsiElement)element, elementClass);
        while (currentElement != null) {
            result.add(currentElement);
            currentElement = PsiTreeUtil.getNextSiblingOfType((PsiElement)currentElement, elementClass);
        }
        return result;
    }
}

