/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.osmorc.manifest.BundleManifest;
import org.osmorc.manifest.impl.AbstractManifestHolderImpl;
import org.osmorc.manifest.impl.BundleManifestImpl;

public class LibraryManifestHolderImpl
extends AbstractManifestHolderImpl {
    private BundleManifest _bundleManifest;
    private final Library _library;
    private final Project _project;

    public LibraryManifestHolderImpl(Library library, Project project) {
        this._library = library;
        this._project = project;
    }

    public BundleManifest getBundleManifest() {
        if (this._bundleManifest == null) {
            VirtualFile[] classRoots;
            for (VirtualFile classRoot : classRoots = this._library.getFiles(OrderRootType.CLASSES)) {
                VirtualFile manifestFile;
                VirtualFile classDir = classRoot.isDirectory() ? classRoot : JarFileSystem.getInstance().getJarRootForLocalFile(classRoot);
                if (classDir == null || (manifestFile = classDir.findFileByRelativePath("META-INF/MANIFEST.MF")) == null) continue;
                PsiFile psiFile = (PsiFile)new ReadAction<PsiFile>(){

                    protected void run(Result<PsiFile> psiFileResult) throws Throwable {
                        psiFileResult.setResult((Object)PsiManager.getInstance((Project)LibraryManifestHolderImpl.this._project).findFile(manifestFile));
                    }
                }.execute().getResultObject();
                this._bundleManifest = new BundleManifestImpl(psiFile);
            }
        }
        return this._bundleManifest;
    }
}

