/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.ManifestHolder;
import org.osmorc.manifest.ManifestHolderRegistry;
import org.osmorc.manifest.impl.LibraryManifestHolderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManifestHolderRegistryImpl
implements ManifestHolderRegistry {
    private final Project project;
    private final Map<Library, ManifestHolder> libraryManifestHolders;

    public ManifestHolderRegistryImpl(Project project) {
        this.project = project;
        this.libraryManifestHolders = new HashMap<Library, ManifestHolder>();
    }

    @Override
    public ManifestHolder getManifestHolder(@NotNull Object bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/impl/ManifestHolderRegistryImpl.getManifestHolder must not be null");
        }
        if (bundle instanceof Module) {
            return this.getModuleManifestHolder((Module)bundle);
        }
        if (bundle instanceof Library) {
            return this.getLibraryManifestHolder((Library)bundle);
        }
        throw new RuntimeException("The bundle is neither a Module nor a Library. It is of type " + bundle.getClass().getName());
    }

    private ManifestHolder getModuleManifestHolder(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/impl/ManifestHolderRegistryImpl.getModuleManifestHolder must not be null");
        }
        return (ManifestHolder)ModuleServiceManager.getService((Module)module, ManifestHolder.class);
    }

    private ManifestHolder getLibraryManifestHolder(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/impl/ManifestHolderRegistryImpl.getLibraryManifestHolder must not be null");
        }
        ManifestHolder result = this.libraryManifestHolders.get(library);
        if (result == null) {
            result = new LibraryManifestHolderImpl(library, this.project);
            this.libraryManifestHolders.put(library, result);
        }
        return result;
    }

    @Override
    public List<Long> getLibraryBundleIDs() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ManifestHolder manifestHolder : this.libraryManifestHolders.values()) {
            ids.add(manifestHolder.getBundleID());
        }
        return ids;
    }

    @Override
    public void clearLibraryManifestHolders() {
        this.libraryManifestHolders.clear();
    }
}

