/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.manifest.BundleManifest;
import org.osmorc.manifest.impl.AbstractManifestHolderImpl;
import org.osmorc.manifest.impl.BundleManifestImpl;

public class ModuleManifestHolderImpl
extends AbstractManifestHolderImpl {
    private final Module module;
    private final Application application;
    private BundleManifest bundleManifest;

    public ModuleManifestHolderImpl(Module module, Application application) {
        this.module = module;
        this.application = application;
    }

    @Nullable
    public BundleManifest getBundleManifest() {
        OsmorcFacet facet;
        VirtualFile cachedFile = this.bundleManifest != null ? this.bundleManifest.getManifestFile().getVirtualFile() : null;
        VirtualFile fileFromSettings = this.getManifestFile();
        if (!(this.bundleManifest == null || cachedFile != null && fileFromSettings != null && cachedFile.getPath().equals(fileFromSettings.getPath()))) {
            this.bundleManifest = null;
        }
        if (this.bundleManifest == null && OsmorcFacet.hasOsmorcFacet(this.module) && ((OsmorcFacetConfiguration)(facet = OsmorcFacet.getInstance(this.module)).getConfiguration()).isManifestManuallyEdited()) {
            this.bundleManifest = this.loadManifest();
        }
        return this.bundleManifest;
    }

    private BundleManifest loadManifest() {
        final VirtualFile manifestFile = this.getManifestFile();
        if (manifestFile != null) {
            return (BundleManifest)this.application.runReadAction((Computable)new Computable<BundleManifest>(){

                public BundleManifest compute() {
                    PsiFile psiFile = PsiManager.getInstance((Project)ModuleManifestHolderImpl.this.module.getProject()).findFile(manifestFile);
                    if (psiFile == null) {
                        return null;
                    }
                    return new BundleManifestImpl(psiFile);
                }
            });
        }
        return null;
    }

    @Nullable
    private VirtualFile getManifestFile() {
        VirtualFile[] contentRoots;
        String path = this.getManifestPath();
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        for (VirtualFile contentRoot : contentRoots = this.getContentRoots()) {
            VirtualFile manifestFile = contentRoot.findFileByRelativePath(path);
            if (manifestFile == null) continue;
            return manifestFile;
        }
        return null;
    }

    @Nullable
    private String getManifestPath() {
        OsmorcFacet facet = OsmorcFacet.getInstance(this.module);
        if (facet == null) {
            return null;
        }
        String path = facet.getManifestLocation();
        path = path.replace('\\', '/');
        return path;
    }

    private VirtualFile[] getContentRoots() {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)this.module);
        return moduleRootManager.getContentRoots();
    }
}

