/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import org.osmorc.manifest.lang.ManifestColorsAndFonts;
import org.osmorc.manifest.lang.ManifestTokenType;
import org.osmorc.manifest.lang.psi.Attribute;
import org.osmorc.manifest.lang.psi.Clause;
import org.osmorc.manifest.lang.psi.Directive;
import org.osmorc.manifest.lang.psi.Header;
import org.osmorc.manifest.lang.psi.ManifestToken;

public class ManifestHighlightingAnnotator
implements Annotator {
    public void annotate(PsiElement psiElement, AnnotationHolder holder) {
        if (psiElement instanceof Attribute) {
            this.annotate(((Attribute)psiElement).getNamePsi(), ManifestColorsAndFonts.ATTRIBUTE_NAME_KEY, holder);
        } else if (psiElement instanceof Directive) {
            this.annotate(((Directive)psiElement).getNamePsi(), ManifestColorsAndFonts.DIRECTIVE_NAME_KEY, holder);
        } else if (psiElement instanceof ManifestToken) {
            ManifestToken manifestToken = (ManifestToken)psiElement;
            if (manifestToken.getParent() instanceof Attribute && manifestToken.getTokenType() == ManifestTokenType.EQUALS) {
                this.annotate(manifestToken, ManifestColorsAndFonts.ATTRIBUTE_ASSIGNMENT_KEY, holder);
            } else if (manifestToken.getParent() instanceof Directive && (manifestToken.getTokenType() == ManifestTokenType.COLON || manifestToken.getTokenType() == ManifestTokenType.EQUALS)) {
                this.annotate(manifestToken, ManifestColorsAndFonts.DIRECTIVE_ASSIGNMENT_KEY, holder);
            } else if (manifestToken.getParent() instanceof Clause && manifestToken.getTokenType() == ManifestTokenType.SEMICOLON) {
                this.annotate(manifestToken, ManifestColorsAndFonts.PARAMETER_SEPARATOR_KEY, holder);
            } else if (manifestToken.getParent() instanceof Header && manifestToken.getTokenType() == ManifestTokenType.COMMA) {
                this.annotate(manifestToken, ManifestColorsAndFonts.CLAUSE_SEPARATOR_KEY, holder);
            }
        }
    }

    private void annotate(PsiElement element, TextAttributesKey textAttributesKey, AnnotationHolder holder) {
        holder.createInformationAnnotation(element, null).setTextAttributes(textAttributesKey);
    }
}

