/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.osmorc.manifest.lang.ManifestTokenType;

public class ManifestLexer
extends LexerBase {
    private CharSequence buffer;
    private int endOffset;
    private int tokenStart;
    private int tokenEnd;
    private int currentState;
    private IElementType tokenType;
    private static final int INITIAL_STATE = 0;
    private static final int WAITING_FOR_HEADER_ASSIGNMENT_STATE = 1;
    private static final int WAITING_FOR_HEADER_ASSIGNMENT_AFTER_BAD_CHARACTER_STATE = 2;
    private static final int WAITING_FOR_SPACE_AFTER_HEADER_NAME_STATE = 3;
    private static final Map<Character, IElementType> SPECIAL_CHARACTERS_TOKEN_MAPPING = new HashMap<Character, IElementType>();

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.buffer = buffer;
        this.endOffset = endOffset;
        this.currentState = initialState;
        this.tokenStart = startOffset;
        this.parseNextToken();
    }

    public void advance() {
        this.tokenStart = this.tokenEnd;
        this.parseNextToken();
    }

    public int getState() {
        return this.currentState;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.tokenType;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public int getBufferEnd() {
        return this.endOffset;
    }

    public CharSequence getBufferSequence() {
        return this.buffer;
    }

    private void parseNextToken() {
        if (this.tokenStart < this.endOffset) {
            if (this.isNewline(this.tokenStart)) {
                this.tokenType = this.isLineStart(this.tokenStart) ? ManifestTokenType.SECTION_END : ManifestTokenType.NEWLINE;
                this.tokenEnd = this.tokenStart + 1;
                this.currentState = 0;
            } else if (this.currentState == 1 || this.currentState == 2) {
                if (this.isColon(this.tokenStart)) {
                    this.tokenType = ManifestTokenType.COLON;
                    this.currentState = 3;
                } else {
                    this.tokenType = TokenType.BAD_CHARACTER;
                    this.currentState = 2;
                }
                this.tokenEnd = this.tokenStart + 1;
            } else if (this.currentState == 3) {
                this.tokenType = this.isSpace(this.tokenStart) ? ManifestTokenType.SIGNIFICANT_SPACE : TokenType.BAD_CHARACTER;
                this.currentState = 0;
                this.tokenEnd = this.tokenStart + 1;
            } else if (this.isHeaderStart(this.tokenStart)) {
                if (this.isAlphaNum(this.tokenStart)) {
                    this.tokenEnd = this.tokenStart + 1;
                    while (this.tokenEnd < this.endOffset && this.isHeaderChar(this.tokenEnd)) {
                        ++this.tokenEnd;
                    }
                }
                this.tokenType = ManifestTokenType.HEADER_NAME;
                this.currentState = 1;
            } else if (this.isContinuationStart(this.tokenStart)) {
                this.tokenType = ManifestTokenType.SIGNIFICANT_SPACE;
                this.tokenEnd = this.tokenStart + 1;
                this.currentState = 0;
            } else if (this.isSpecialCharacter(this.tokenStart)) {
                this.tokenType = this.getTokenTypeForSpecialCharacter(this.tokenStart);
                this.tokenEnd = this.tokenStart + 1;
                this.currentState = 0;
            } else {
                this.tokenEnd = this.tokenStart;
                while (this.tokenEnd < this.endOffset && !this.isSpecialCharacter(this.tokenEnd) && !this.isNewline(this.tokenEnd)) {
                    ++this.tokenEnd;
                }
                this.tokenType = ManifestTokenType.HEADER_VALUE_PART;
            }
        } else {
            this.tokenType = null;
            this.tokenEnd = this.tokenStart;
        }
    }

    private boolean isNewline(int position) {
        return '\n' == this.buffer.charAt(position);
    }

    private boolean isHeaderStart(int position) {
        return this.isLineStart(position) && !Character.isWhitespace(this.buffer.charAt(position));
    }

    private boolean isAlphaNum(int position) {
        return Character.isLetterOrDigit(this.buffer.charAt(position));
    }

    private boolean isHeaderChar(int position) {
        return this.isAlphaNum(position) || this.buffer.charAt(position) == '-' || this.buffer.charAt(position) == '_';
    }

    private boolean isContinuationStart(int position) {
        return this.isLineStart(position) && !this.isHeaderStart(position);
    }

    private boolean isLineStart(int position) {
        return position == 0 || this.isNewline(position - 1);
    }

    private boolean isSpace(int position) {
        return this.buffer.charAt(position) == ' ';
    }

    private boolean isColon(int position) {
        return this.buffer.charAt(position) == ':';
    }

    private boolean isSpecialCharacter(int position) {
        return SPECIAL_CHARACTERS_TOKEN_MAPPING.get(Character.valueOf(this.buffer.charAt(position))) != null;
    }

    private IElementType getTokenTypeForSpecialCharacter(int position) {
        return SPECIAL_CHARACTERS_TOKEN_MAPPING.get(Character.valueOf(this.buffer.charAt(position)));
    }

    static {
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(':'), ManifestTokenType.COLON);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(';'), ManifestTokenType.SEMICOLON);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(','), ManifestTokenType.COMMA);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('='), ManifestTokenType.EQUALS);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('\"'), ManifestTokenType.QUOTE);
    }
}

