/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.lang.ManifestElementTypes;
import org.osmorc.manifest.lang.ManifestTokenType;
import org.osmorc.manifest.lang.headerparser.HeaderParser;
import org.osmorc.manifest.lang.headerparser.HeaderParserRepository;

class ManifestParser
implements PsiParser {
    private String currentHeaderName;
    private boolean currentHeaderIsSimpleHeader;
    private final HeaderParserRepository headerParserRepository;
    private PsiBuilder.Marker headerValuePartMarker;
    private PsiBuilder.Marker sectionMarker;
    private PsiBuilder.Marker headerMarker;
    private PsiBuilder.Marker clauseMarker;
    private PsiBuilder.Marker assignmentMarker;
    private IElementType assignmentMarkerType;
    private static final boolean DEBUG_MODE = Boolean.getBoolean("Osmorc.debug");

    ManifestParser(@NotNull HeaderParserRepository headerParserRepository) {
        if (headerParserRepository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/lang/ManifestParser.<init> must not be null");
        }
        this.headerParserRepository = headerParserRepository;
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        builder.setDebugMode(DEBUG_MODE);
        PsiBuilder.Marker rootMarker = builder.mark();
        while (!builder.eof()) {
            this.parse(builder);
        }
        this.closeAssignmentMarker();
        this.closeClause();
        this.closeHeader();
        this.closeSection();
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/manifest/lang/ManifestParser.parse must not return null");
        }
        return aSTNode;
    }

    protected void parse(PsiBuilder builder) {
        if (this.sectionMarker == null) {
            this.sectionMarker = builder.mark();
        }
        if (builder.getTokenType() == ManifestTokenType.HEADER_NAME) {
            this.parseHeaderName(builder);
        } else if (builder.getTokenType() == ManifestTokenType.SECTION_END) {
            this.closeSection();
            builder.advanceLexer();
        } else if (builder.getTokenType() == ManifestTokenType.SIGNIFICANT_SPACE || builder.getTokenType() == TokenType.BAD_CHARACTER || builder.getTokenType() == ManifestTokenType.NEWLINE) {
            builder.advanceLexer();
        } else if (this.currentHeaderIsSimpleHeader) {
            this.parseSimpleHeaderValue(builder);
        } else {
            this.parseComplexHeaderValue(builder);
        }
    }

    private void parseSimpleHeaderValue(PsiBuilder builder) {
        this.clauseMarker = builder.mark();
        this.headerValuePartMarker = builder.mark();
        while (!builder.eof() && builder.getTokenType() != ManifestTokenType.SECTION_END && builder.getTokenType() != ManifestTokenType.HEADER_NAME) {
            builder.advanceLexer();
        }
        this.closeHeaderValuePart();
        this.closeClause();
        this.closeHeader();
    }

    private void parseComplexHeaderValue(PsiBuilder builder) {
        while (!builder.eof() && builder.getTokenType() != ManifestTokenType.SECTION_END && builder.getTokenType() != ManifestTokenType.HEADER_NAME) {
            boolean lexerAdvanced;
            if (this.clauseMarker == null) {
                this.clauseMarker = builder.mark();
            }
            if (this.headerValuePartMarker == null) {
                this.headerValuePartMarker = builder.mark();
            }
            if (lexerAdvanced = this.parseQuotedString(builder) || this.parseClause(builder) || this.parseParameter(builder) || this.parseDirective(builder) || this.parseAttribute(builder)) continue;
            builder.advanceLexer();
        }
        this.closeHeaderValuePart();
        this.closeAssignmentMarker();
        this.closeClause();
        this.closeHeader();
    }

    private boolean parseQuotedString(PsiBuilder builder) {
        if (builder.getTokenType() == ManifestTokenType.QUOTE) {
            do {
                builder.advanceLexer();
            } while (!builder.eof() && builder.getTokenType() != ManifestTokenType.QUOTE && builder.getTokenType() != ManifestTokenType.SECTION_END && builder.getTokenType() != ManifestTokenType.HEADER_NAME);
            if (builder.getTokenType() == ManifestTokenType.QUOTE) {
                builder.advanceLexer();
            }
            return true;
        }
        return false;
    }

    private boolean parseClause(PsiBuilder builder) {
        if (builder.getTokenType() == ManifestTokenType.COMMA) {
            this.closeHeaderValuePart();
            this.closeAssignmentMarker();
            this.closeClause();
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    private boolean parseParameter(PsiBuilder builder) {
        if (builder.getTokenType() == ManifestTokenType.SEMICOLON) {
            this.closeHeaderValuePart();
            this.closeAssignmentMarker();
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    private boolean parseDirective(PsiBuilder builder) {
        if (builder.getTokenType() == ManifestTokenType.COLON && this.assignmentMarkerType == null) {
            this.assignmentMarker = this.headerValuePartMarker.precede();
            this.assignmentMarkerType = ManifestElementTypes.DIRECTIVE;
            this.closeHeaderValuePart();
            builder.advanceLexer();
            if (builder.getTokenType() == ManifestTokenType.NEWLINE) {
                builder.advanceLexer();
                if (builder.getTokenType() == ManifestTokenType.SIGNIFICANT_SPACE) {
                    builder.advanceLexer();
                }
            }
            if (builder.getTokenType() == ManifestTokenType.EQUALS) {
                builder.advanceLexer();
            }
            return true;
        }
        return false;
    }

    private boolean parseAttribute(PsiBuilder builder) {
        if (builder.getTokenType() == ManifestTokenType.EQUALS && this.assignmentMarkerType == null) {
            this.assignmentMarker = this.headerValuePartMarker.precede();
            this.assignmentMarkerType = ManifestElementTypes.ATTRIBUTE;
            this.closeHeaderValuePart();
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    private void parseHeaderName(PsiBuilder builder) {
        this.closeHeader();
        this.headerMarker = builder.mark();
        this.currentHeaderName = builder.getTokenText();
        HeaderParser headerParser = this.headerParserRepository.getHeaderParser(this.currentHeaderName);
        this.currentHeaderIsSimpleHeader = headerParser == null || headerParser.isSimpleHeader();
        builder.advanceLexer();
        while (!builder.eof() && builder.getTokenType() != ManifestTokenType.COLON && builder.getTokenType() != ManifestTokenType.NEWLINE) {
            builder.advanceLexer();
        }
        builder.advanceLexer();
    }

    private void closeHeader() {
        if (this.headerMarker != null) {
            this.headerMarker.done(ManifestElementTypes.HEADER);
            this.headerMarker = null;
        }
    }

    private void closeClause() {
        if (this.clauseMarker != null) {
            this.clauseMarker.done(ManifestElementTypes.CLAUSE);
            this.clauseMarker = null;
        }
    }

    private void closeSection() {
        if (this.sectionMarker != null) {
            this.sectionMarker.done(ManifestElementTypes.SECTION);
            this.sectionMarker = null;
        }
    }

    private void closeAssignmentMarker() {
        if (this.assignmentMarker != null) {
            this.assignmentMarker.done(this.assignmentMarkerType);
            this.assignmentMarker = null;
            this.assignmentMarkerType = null;
        }
    }

    private void closeHeaderValuePart() {
        if (this.headerValuePartMarker != null) {
            this.headerValuePartMarker.done(ManifestElementTypes.HEADER_VALUE_PART);
            this.headerValuePartMarker = null;
        }
    }
}

