/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.headerparser;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.lang.headerparser.HeaderNameMatch;
import org.osmorc.manifest.lang.headerparser.HeaderParser;
import org.osmorc.manifest.lang.headerparser.HeaderParserProvider;
import org.osmorc.manifest.lang.headerparser.HeaderParserProviderRepository;
import org.osmorc.manifest.lang.headerparser.impl.AbstractHeaderParserImpl;
import org.osmorc.manifest.lang.psi.Header;
import org.osmorc.manifest.lang.psi.HeaderValuePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderParserRepository {
    private final HeaderParserProviderRepository[] _headerParserProviderRepositories = (HeaderParserProviderRepository[])Extensions.getExtensions((ExtensionPointName)new ExtensionPointName("Osmorc.headerParserProviderRepository"));

    public static HeaderParserRepository getInstance() {
        return (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);
    }

    public HeaderParser getHeaderParser(@NotNull HeaderValuePart manifestHeaderValue) {
        if (manifestHeaderValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/lang/headerparser/HeaderParserRepository.getHeaderParser must not be null");
        }
        Header manifestHeader = this.findHeader(manifestHeaderValue);
        String headerName = manifestHeader != null ? manifestHeader.getName() : null;
        return this.getHeaderParser(headerName);
    }

    public HeaderParser getHeaderParser(@NotNull Header manifestHeader) {
        if (manifestHeader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/lang/headerparser/HeaderParserRepository.getHeaderParser must not be null");
        }
        return this.getHeaderParser(manifestHeader.getName());
    }

    public HeaderParser getHeaderParser(String headerName) {
        if (headerName != null) {
            for (HeaderParserProviderRepository headerParserProviderRepository : this._headerParserProviderRepositories) {
                for (HeaderParserProvider headerParserProvider : headerParserProviderRepository.getHeaderParserProviders()) {
                    if (!headerName.equalsIgnoreCase(headerParserProvider.getHeaderName())) continue;
                    return headerParserProvider.getHeaderParser();
                }
            }
        }
        return AbstractHeaderParserImpl.SIMPLE;
    }

    public Collection<HeaderNameMatch> getMatches(@NotNull String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/manifest/lang/headerparser/HeaderParserRepository.getMatches must not be null");
        }
        TreeSet<HeaderNameMatch> result = new TreeSet<HeaderNameMatch>();
        for (HeaderParserProviderRepository headerParserProviderRepository : this._headerParserProviderRepositories) {
            for (HeaderParserProvider headerParserProvider : headerParserProviderRepository.getHeaderParserProviders()) {
                if (headerName.equals(headerParserProvider.getHeaderName())) {
                    return new ArrayList<HeaderNameMatch>();
                }
                result.add(new HeaderNameMatch(StringUtils.getLevenshteinDistance((String)headerName, (String)headerParserProvider.getHeaderName()), headerParserProvider));
            }
        }
        return result;
    }

    public Set<String> getAllHeaderNames() {
        HashSet<String> result = new HashSet<String>();
        for (HeaderParserProviderRepository headerParserProviderRepository : this._headerParserProviderRepositories) {
            Collection<HeaderParserProvider> headerParserProviders = headerParserProviderRepository.getHeaderParserProviders();
            for (HeaderParserProvider headerParserProvider : headerParserProviders) {
                result.add(headerParserProvider.getHeaderName());
            }
        }
        return result;
    }

    private Header findHeader(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Header) {
            return (Header)element;
        }
        return this.findHeader(element.getParent());
    }
}

