/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.psi;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.manifest.lang.psi.PackageReferenceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    private final PackageReferenceSet myReferenceSet;
    private final int myIndex;
    private final GlobalSearchScope _moduleWithLibrariesScope;

    public PackageReference(PackageReferenceSet set, TextRange range, int index) {
        super(set.getElement(), range);
        this.myReferenceSet = set;
        this.myIndex = index;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)set.getElement());
        this._moduleWithLibrariesScope = module != null ? module.getModuleWithLibrariesScope() : GlobalSearchScope.allScope((Project)set.getElement().getProject());
    }

    @Nullable
    private PsiPackage getPsiPackage() {
        return this.myIndex == 0 ? JavaPsiFacade.getInstance((Project)this.getElement().getProject()).findPackage("") : ((PackageReference)this.myReferenceSet.getReference(this.myIndex - 1)).resolve();
    }

    public boolean isSoft() {
        return true;
    }

    @Nullable
    public PsiPackage resolve() {
        PsiPackage parentPackage = this.getPsiPackage();
        if (parentPackage != null) {
            for (PsiPackage aPackage : parentPackage.getSubPackages(this._moduleWithLibrariesScope)) {
                if (!Comparing.equal((String)aPackage.getName(), (String)this.getCanonicalText())) continue;
                return aPackage;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        PsiPackage psiPackage = this.getPsiPackage();
        if (psiPackage == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method org/osmorc/manifest/lang/psi/PackageReference.getVariants must not return null");
            return objectArray;
        }
        PsiPackage[] psiPackages = psiPackage.getSubPackages(this._moduleWithLibrariesScope);
        Object[] variants = new Object[psiPackages.length];
        System.arraycopy(psiPackages, 0, variants, 0, variants.length);
        objectArray = variants;
        if (variants != null) return objectArray;
        throw new IllegalStateException("@NotNull method org/osmorc/manifest/lang/psi/PackageReference.getVariants must not return null");
    }

    public String getUnresolvedMessagePattern() {
        return "Cannot resolve symbol";
    }
}

