/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.lang.ManifestTokenType;
import org.osmorc.manifest.lang.headerparser.HeaderParser;
import org.osmorc.manifest.lang.headerparser.HeaderParserRepository;
import org.osmorc.manifest.lang.psi.HeaderValuePart;
import org.osmorc.manifest.lang.psi.ManifestToken;
import org.osmorc.manifest.lang.psi.impl.ManifestElementBase;
import org.osmorc.manifest.lang.psi.stub.HeaderValuePartStub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderValuePartImpl
extends ManifestElementBase<HeaderValuePartStub>
implements HeaderValuePart {
    private final HeaderParserRepository headerParserRepository;

    public HeaderValuePartImpl(HeaderValuePartStub stub, @NotNull IStubElementType nodeType) {
        if (nodeType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/manifest/lang/psi/impl/HeaderValuePartImpl.<init> must not be null");
        }
        super(stub, nodeType);
        this.headerParserRepository = (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);
    }

    public HeaderValuePartImpl(ASTNode node) {
        super(node);
        this.headerParserRepository = (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);
    }

    @Override
    public String getUnwrappedText() {
        String result;
        HeaderValuePartStub stub = (HeaderValuePartStub)this.getStub();
        if (stub != null) {
            result = stub.getUnwrappedText();
        } else {
            StringBuilder builder = new StringBuilder();
            for (PsiElement element = this.getFirstChild(); element != null; element = element.getNextSibling()) {
                ManifestToken manifestToken;
                boolean ignore = false;
                if (element instanceof ManifestToken && ((manifestToken = (ManifestToken)element).getTokenType() == ManifestTokenType.NEWLINE || manifestToken.getTokenType() == ManifestTokenType.SIGNIFICANT_SPACE)) {
                    ignore = true;
                }
                if (ignore) continue;
                builder.append(element.getText());
            }
            result = builder.toString();
        }
        return result.trim();
    }

    @Override
    public Object getConvertedValue() {
        HeaderParser headerParser = this.headerParserRepository.getHeaderParser(this);
        if (headerParser != null) {
            return headerParser.getValue(this);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray;
        HeaderParser headerParser = this.headerParserRepository.getHeaderParser(this);
        if (headerParser != null) {
            psiReferenceArray = headerParser.getReferences(this);
            if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method org/osmorc/manifest/lang/psi/impl/HeaderValuePartImpl.getReferences must not return null");
            return psiReferenceArray;
        }
        psiReferenceArray = PsiReference.EMPTY_ARRAY;
        if (PsiReference.EMPTY_ARRAY != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method org/osmorc/manifest/lang/psi/impl/HeaderValuePartImpl.getReferences must not return null");
    }
}

