/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.valueparser.impl;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.TextRange;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.osmorc.manifest.lang.psi.HeaderValuePart;
import org.osmorc.manifest.lang.valueparser.impl.AbstractValueParserImpl;
import org.osmorc.valueobject.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionParser
extends AbstractValueParserImpl<Version> {
    private final Pattern _qualifierPattern = Pattern.compile("[\\w\\-]*");

    @Override
    protected Version parseValue(@Nullable HeaderValuePart headerValue, String text, int start, @Nullable AnnotationHolder annotationHolder) {
        int componentStart;
        String[] componentNames = new String[]{"major", "minor", "micro"};
        int[] components = new int[]{0, 0, 0};
        int componentEnd = -1;
        for (int componentIdx = 0; componentIdx < components.length; ++componentIdx) {
            componentStart = componentEnd + 1;
            if ((componentEnd = text.indexOf(46, componentStart)) < 0) {
                componentEnd = text.length();
            }
            try {
                components[componentIdx] = Integer.parseInt(text.substring(componentStart, componentEnd));
            }
            catch (NumberFormatException e) {
                this.createInvalidNumberAnnotation(headerValue, componentStart + start, componentEnd + start, annotationHolder, componentNames[componentIdx]);
            }
            if (componentEnd == text.length()) break;
        }
        String qualifier = "";
        if (componentEnd < text.length()) {
            componentStart = componentEnd + 1;
            componentEnd = text.length();
            qualifier = text.substring(componentStart);
            if (annotationHolder != null && !this._qualifierPattern.matcher(qualifier).matches()) {
                TextRange headerValueTextRange = headerValue.getTextRange();
                TextRange textRange = new TextRange(headerValueTextRange.getStartOffset() + componentStart, headerValueTextRange.getStartOffset() + componentEnd);
                annotationHolder.createErrorAnnotation(textRange, "The qualifier component of the defined version is invalid. It may only contain alphanumeric characters, '-' and '_'");
            }
        }
        return new Version(components[0], components[1], components[2], qualifier);
    }

    void createInvalidNumberAnnotation(@Nullable HeaderValuePart headerValuePart, int start, int end, @Nullable AnnotationHolder annotationHolder, String component) {
        if (annotationHolder != null) {
            TextRange headerValueTextRange = headerValuePart.getTextRange();
            TextRange textRange = new TextRange(headerValueTextRange.getStartOffset() + start, headerValueTextRange.getStartOffset() + end);
            annotationHolder.createErrorAnnotation(textRange, "The " + component + " component of the defined version is not a valid number");
        }
    }
}

