/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.valueparser.impl;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.Nullable;
import org.osmorc.manifest.lang.psi.HeaderValuePart;
import org.osmorc.manifest.lang.valueparser.impl.AbstractValueParserImpl;
import org.osmorc.manifest.lang.valueparser.impl.VersionParser;
import org.osmorc.valueobject.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionRangeParser
extends AbstractValueParserImpl<VersionRange> {
    private final VersionParser _versionParser;

    public VersionRangeParser(VersionParser versionParser) {
        this._versionParser = versionParser;
    }

    @Override
    protected VersionRange parseValue(@Nullable HeaderValuePart headerValuePart, String text, int start, @Nullable AnnotationHolder annotationHolder) {
        VersionRange.Boundary floorBoundary = null;
        Object floor = null;
        Object ceiling = null;
        Object ceilingBoundary = null;
        int nextStart = start;
        int nextEnd = nextStart + 1;
        if (text.charAt(nextStart) == '[' || text.charAt(nextStart) == '(') {
            if (annotationHolder != null) {
                annotationHolder.createErrorAnnotation(this.createTextRange(headerValuePart, nextStart, nextEnd), "Version ranges have to be enclosed in double quotes.");
            }
            ++nextStart;
        } else if (text.charAt(nextStart) == '\"') {
            ++nextStart;
            while (Character.isWhitespace(text.charAt(nextStart))) {
                ++nextStart;
            }
            if (text.charAt(nextStart) == '[') {
                floorBoundary = VersionRange.Boundary.INCLUSIVE;
            } else if (text.charAt(nextStart) == '(') {
                floorBoundary = VersionRange.Boundary.EXCLUSIVE;
            } else {
                nextEnd = nextStart + 1;
                while (!Character.isDigit(text.charAt(nextEnd))) {
                    ++nextEnd;
                }
                if (annotationHolder != null) {
                    Annotation annotation = annotationHolder.createErrorAnnotation(this.createTextRange(headerValuePart, nextStart, nextEnd), "Invalid boundary definition");
                }
            }
        }
        nextEnd = text.indexOf(44);
        return null;
    }

    private TextRange createTextRange(HeaderValuePart headerValuePart, int startInValue, int endInValue) {
        int headerValueStartOffset = headerValuePart.getTextRange().getStartOffset();
        return new TextRange(headerValueStartOffset + startInValue, headerValueStartOffset + endInValue);
    }
}

