/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.obrimport.springsource;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.io.UrlConnectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.osmorc.obrimport.MavenRepository;
import org.osmorc.obrimport.Obr;
import org.osmorc.obrimport.springsource.ObrMavenResult;

public class SpringSourceObr
implements Obr {
    private static final Pattern RESULT_PARSING_PATTERN = Pattern.compile("<a\\s+href=\"([^\"]+)\"[^>]*>([^<]+)");
    private static final Pattern GROUP_ID_PATTERN = Pattern.compile("&lt;groupId&gt;(.*?)&lt;/groupId&gt;");
    private static final Pattern ARTIFACT_ID_PATTERN = Pattern.compile("&lt;artifactId&gt;(.*?)&lt;/artifactId&gt;");
    private static final Pattern VERSION_PATTERN = Pattern.compile("&lt;version&gt;(.*?)&lt;/version&gt;");
    private static final Pattern CLASSIFIER_PATTERN = Pattern.compile("&lt;classifier&gt;(.*?)&lt;/classifier&gt;");
    private static final MavenRepository[] SPRINGSOURCE_REPOS = new MavenRepository[]{new MavenRepository("repository.springsource.com.release", "SpringSource OBR - Release", "http://repository.springsource.com/maven/bundles/release"), new MavenRepository("repository.springsource.com.external", "SpringSource OBR - External", "http://repository.springsource.com/maven/bundles/external")};

    public String getDisplayName() {
        return "Springsource Enterprise Bundle Repository";
    }

    public boolean supportsMaven() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ObrMavenResult[] queryForMavenArtifact(@NotNull String queryString, @NotNull ProgressIndicator progressIndicator) throws IOException {
        ObrMavenResult[] obrMavenResultArray;
        if (queryString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/obrimport/springsource/SpringSourceObr.queryForMavenArtifact must not be null");
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/obrimport/springsource/SpringSourceObr.queryForMavenArtifact must not be null");
        }
        try {
            ArrayList<ObrMavenResult> result = new ArrayList<ObrMavenResult>();
            progressIndicator.setText("Connecting to " + this.getDisplayName() + "...");
            String url = "http://www.springsource.com/repository/app/search?query=" + URLEncoder.encode(queryString, "utf-8");
            InputStream is = SpringSourceObr.getInputStream(url, progressIndicator);
            String contents = StreamUtil.readText((InputStream)is, (String)"utf-8");
            progressIndicator.setText("Search completed. Getting results.");
            progressIndicator.checkCanceled();
            int start = contents.indexOf("<div id=\"results-fragment\">");
            int end = contents.indexOf("</div>", start);
            contents = contents.substring(start, end);
            is.close();
            Matcher m = RESULT_PARSING_PATTERN.matcher(contents);
            while (m.find()) {
                String detailUrl = m.group(1);
                detailUrl = detailUrl.replaceAll(";jsessionid.*?\\?", "?");
                detailUrl = detailUrl.replace("&amp;", "&");
                String packageName = m.group(2);
                progressIndicator.setText("Loading details for result " + packageName + "...");
                is = SpringSourceObr.getInputStream("http://www.springsource.com" + detailUrl, progressIndicator);
                String detail = StreamUtil.readText((InputStream)is, (String)"utf-8");
                is.close();
                progressIndicator.checkCanceled();
                progressIndicator.setText("Details retrieved. Getting detail information...");
                String classifier = null;
                Matcher groupMatcher = GROUP_ID_PATTERN.matcher(detail);
                if (!groupMatcher.find()) continue;
                String groupId = groupMatcher.group(1);
                Matcher artifactMatcher = ARTIFACT_ID_PATTERN.matcher(detail);
                if (!artifactMatcher.find()) continue;
                String artifactId = artifactMatcher.group(1);
                Matcher versionMatcher = VERSION_PATTERN.matcher(detail);
                if (!versionMatcher.find()) continue;
                String version = versionMatcher.group(1);
                Matcher classifierMatcher = CLASSIFIER_PATTERN.matcher(detail);
                if (classifierMatcher.find()) {
                    classifier = classifierMatcher.group(1);
                }
                result.add(new ObrMavenResult(groupId, artifactId, version, classifier, this));
            }
            progressIndicator.setText("Done. " + result.size() + " artifacts found.");
            ObrMavenResult[] obrMavenResultArray2 = result.toArray(new ObrMavenResult[result.size()]);
            obrMavenResultArray = obrMavenResultArray2;
            if (obrMavenResultArray2 != null) return obrMavenResultArray;
            throw new IllegalStateException("@NotNull method org/osmorc/obrimport/springsource/SpringSourceObr.queryForMavenArtifact must not return null");
        }
        catch (ProcessCanceledException ignored) {
            progressIndicator.setText("Canceled.");
            ObrMavenResult[] obrMavenResultArray3 = new ObrMavenResult[]{};
            obrMavenResultArray = obrMavenResultArray3;
            if (obrMavenResultArray3 == null) throw new IllegalStateException("@NotNull method org/osmorc/obrimport/springsource/SpringSourceObr.queryForMavenArtifact must not return null");
            return obrMavenResultArray;
        }
        finally {
            progressIndicator.setIndeterminate(false);
        }
    }

    private static InputStream getInputStream(@NotNull String url, @NotNull ProgressIndicator progressIndicator) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/obrimport/springsource/SpringSourceObr.getInputStream must not be null");
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/obrimport/springsource/SpringSourceObr.getInputStream must not be null");
        }
        HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
        InputStream is = UrlConnectionUtil.getConnectionInputStreamWithException((URLConnection)urlConnection, (ProgressIndicator)progressIndicator);
        int j = urlConnection.getResponseCode();
        switch (j) {
            default: {
                throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{j}));
            }
            case 200: 
        }
        progressIndicator.setIndeterminate(urlConnection.getContentLength() == -1);
        return is;
    }

    @NotNull
    public MavenRepository[] getMavenRepositories() {
        if (SPRINGSOURCE_REPOS == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/obrimport/springsource/SpringSourceObr.getMavenRepositories must not return null");
        }
        return SPRINGSOURCE_REPOS;
    }
}

