/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.OsgiRunState;

public class OsgiDebuggerRunner
extends GenericDebuggerRunner {
    private final Logger logger = Logger.getInstance((String)"#org.osmorc.run.OsgiDebuggerRunner");

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/OsgiDebuggerRunner.canRun must not be null");
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/run/OsgiDebuggerRunner.canRun must not be null");
        }
        return executorId.equals(DefaultDebugExecutor.EXECUTOR_ID) && profile instanceof OsgiRunConfiguration;
    }

    @NotNull
    public String getRunnerId() {
        if ("OsgiDebugRunner" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/run/OsgiDebuggerRunner.getRunnerId must not return null");
        }
        return "OsgiDebugRunner";
    }

    protected RunContentDescriptor createContentDescriptor(Project project, Executor executor, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env) throws ExecutionException {
        OsgiRunState runState = (OsgiRunState)state;
        RunnerSettings myRunnerSettings = state.getRunnerSettings();
        if (runState.requiresRemoteDebugger()) {
            String myDebugPort = null;
            if (myRunnerSettings.getData() instanceof DebuggingRunnerData) {
                myDebugPort = ((DebuggingRunnerData)myRunnerSettings.getData()).getDebugPort();
                if (myDebugPort.length() == 0) {
                    try {
                        myDebugPort = DebuggerUtils.getInstance().findAvailableDebugAddress(true);
                    }
                    catch (ExecutionException e) {
                        this.logger.error((Throwable)e);
                    }
                    ((DebuggingRunnerData)myRunnerSettings.getData()).setDebugPort(myDebugPort);
                }
                ((DebuggingRunnerData)myRunnerSettings.getData()).setLocal(false);
            }
            RemoteConnection connection = new RemoteConnection(true, "127.0.0.1", myDebugPort, true);
            return this.attachVirtualMachine(project, executor, state, contentToReuse, env, connection, false);
        }
        return super.createContentDescriptor(project, executor, state, contentToReuse, env);
    }
}

