/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.LegacyOsgiRunConfigurationLoader;
import org.osmorc.run.OsgiRunConfigurationChecker;
import org.osmorc.run.OsgiRunState;
import org.osmorc.run.ui.OsgiRunConfigurationEditor;
import org.osmorc.run.ui.SelectedBundle;
import org.osmorc.settings.ApplicationSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiRunConfiguration
extends RunConfigurationBase
implements ModuleRunConfiguration {
    @NonNls
    private static final String BUNDLE_ELEMENT = "bundle";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String VM_PARAMETERS_ATTRIBUTE = "vmParameters";
    @NonNls
    private static final String PROGRAM_PARAMETERS_ATTRIBUTE = "programParameters";
    @NonNls
    private static final String WORKING_DIR_ATTRIBUTE = "workingDir";
    @NonNls
    private static final String FRAMEWORK_ELEMENT = "framework";
    @NonNls
    private static final String INSTANCE_ATTRIBUTE = "instance";
    @NonNls
    private static final String URL_ATTRIBUTE = "url";
    @NonNls
    private static final String ADDITIONAL_PROPERTIES_ELEMENT = "additinalProperties";
    @NonNls
    private static final String TYPE_ATTRIBUTE = "type";
    @NonNls
    private static final String START_AFTER_INSTALLATION_ATTRIBUTE = "startAfterInstallation";
    @NonNls
    private static final String START_LEVEL_ATTRIBUTE = "startLevel";
    @NonNls
    private static final String INCLUDE_ALL_BUNDLES_IN_CLASS_PATH_ATTRIBUTE = "includeAllBundlesInClassPath";
    @NonNls
    private static final String USE_ALTERNATIVE_JRE_ATTRIBUTE = "useAlternativeJre";
    @NonNls
    private static final String ALTERNATIVE_JRE_PATH = "alternativeJrePath";
    @NonNls
    private static final String FRAMEWORK_START_LEVEL = "frameworkStartLevel";
    @NonNls
    private static final String DEFAULT_START_LEVEL = "defaultStartLevel";
    @NonNls
    private static final String AUTO_START_LEVEL = "autoStartLevel";
    @NonNls
    public static final String GENERATE_WORKING_DIR_ATTRIBUTE = "generateWorkingDir";
    @Nullable
    private OsgiRunConfigurationChecker checker;
    private LegacyOsgiRunConfigurationLoader legacyOsgiRunConfigurationLoader;
    private List<SelectedBundle> bundlesToDeploy = new ArrayList<SelectedBundle>();
    private int frameworkStartLevel = 1;
    private int defaultStartLevel = 5;
    private boolean autoStartLevel;
    private String programParameters;
    private String vmParameters;
    private String alternativeJrePath;
    private boolean useAlternativeJre;
    private FrameworkInstanceDefinition instanceToUse;
    private Map<String, String> additionalProperties = new HashMap<String, String>();
    private boolean includeAllBundlesInClassPath;
    private String workingDir;
    private boolean generateWorkingDir;

    public OsgiRunConfiguration(Project project, ConfigurationFactory configurationFactory, String name) {
        super(project, configurationFactory, name);
        this.additionalProperties.put("startConsole", String.valueOf(true));
    }

    @Nullable
    public RunConfiguration clone() {
        OsgiRunConfiguration conf = (OsgiRunConfiguration)super.clone();
        if (conf == null) {
            return conf;
        }
        conf.bundlesToDeploy = new ArrayList<SelectedBundle>(this.bundlesToDeploy);
        conf.additionalProperties = new HashMap<String, String>(this.additionalProperties);
        return conf;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element additionalProperties;
        String name;
        Element framework;
        String dfsl;
        this.workingDir = element.getAttributeValue(WORKING_DIR_ATTRIBUTE);
        this.vmParameters = element.getAttributeValue(VM_PARAMETERS_ATTRIBUTE);
        this.programParameters = element.getAttributeValue(PROGRAM_PARAMETERS_ATTRIBUTE);
        this.includeAllBundlesInClassPath = Boolean.valueOf(element.getAttributeValue(INCLUDE_ALL_BUNDLES_IN_CLASS_PATH_ATTRIBUTE, "false"));
        this.useAlternativeJre = Boolean.valueOf(element.getAttributeValue(USE_ALTERNATIVE_JRE_ATTRIBUTE, "false"));
        this.alternativeJrePath = element.getAttributeValue(ALTERNATIVE_JRE_PATH, "");
        this.autoStartLevel = Boolean.valueOf(element.getAttributeValue(AUTO_START_LEVEL));
        this.generateWorkingDir = Boolean.valueOf(element.getAttributeValue(GENERATE_WORKING_DIR_ATTRIBUTE));
        String fwsl = element.getAttributeValue(FRAMEWORK_START_LEVEL);
        if (fwsl != null) {
            try {
                this.frameworkStartLevel = Integer.parseInt(fwsl);
            }
            catch (NumberFormatException e) {
                this.frameworkStartLevel = 1;
            }
        }
        if ((dfsl = element.getAttributeValue(DEFAULT_START_LEVEL)) != null) {
            try {
                this.defaultStartLevel = Integer.parseInt(dfsl);
            }
            catch (NumberFormatException e) {
                this.defaultStartLevel = 5;
            }
        }
        List children = element.getChildren(BUNDLE_ELEMENT);
        this.bundlesToDeploy.clear();
        for (Element child : children) {
            String startAfterInstallationString;
            SelectedBundle.BundleType type;
            String name2 = child.getAttributeValue(NAME_ATTRIBUTE);
            String url = child.getAttributeValue(URL_ATTRIBUTE);
            String startLevel = child.getAttributeValue(START_LEVEL_ATTRIBUTE);
            String typeName = child.getAttributeValue(TYPE_ATTRIBUTE);
            if ("legacyLoader".equals(name2)) {
                try {
                    this.legacyOsgiRunConfigurationLoader = (LegacyOsgiRunConfigurationLoader)Class.forName(url).newInstance();
                    break;
                }
                catch (InstantiationException e) {
                    throw new InvalidDataException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new InvalidDataException((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidDataException((Throwable)e);
                }
            }
            try {
                type = SelectedBundle.BundleType.valueOf(typeName);
            }
            catch (Exception e) {
                type = SelectedBundle.BundleType.Module;
            }
            SelectedBundle selectedBundle = new SelectedBundle(name2, url, type);
            if (startLevel != null) {
                try {
                    selectedBundle.setStartLevel(Integer.parseInt(startLevel));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((startAfterInstallationString = child.getAttributeValue(START_AFTER_INSTALLATION_ATTRIBUTE)) != null) {
                selectedBundle.setStartAfterInstallation(Boolean.parseBoolean(startAfterInstallationString));
            }
            this.bundlesToDeploy.add(selectedBundle);
        }
        if ((framework = element.getChild(FRAMEWORK_ELEMENT)) != null && (name = framework.getAttributeValue(INSTANCE_ATTRIBUTE)) != null) {
            ApplicationSettings settings = (ApplicationSettings)ServiceManager.getService(ApplicationSettings.class);
            this.instanceToUse = settings.getFrameworkInstance(name);
        }
        if ((additionalProperties = element.getChild(ADDITIONAL_PROPERTIES_ELEMENT)) != null) {
            List attributes = additionalProperties.getAttributes();
            for (Attribute attribute : attributes) {
                this.additionalProperties.put(attribute.getName(), attribute.getValue());
            }
        }
        super.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(VM_PARAMETERS_ATTRIBUTE, this.vmParameters == null ? "" : this.vmParameters);
        element.setAttribute(PROGRAM_PARAMETERS_ATTRIBUTE, this.programParameters == null ? "" : this.programParameters);
        element.setAttribute(INCLUDE_ALL_BUNDLES_IN_CLASS_PATH_ATTRIBUTE, Boolean.toString(this.includeAllBundlesInClassPath));
        element.setAttribute(WORKING_DIR_ATTRIBUTE, this.workingDir == null ? "" : this.workingDir);
        element.setAttribute(USE_ALTERNATIVE_JRE_ATTRIBUTE, String.valueOf(this.useAlternativeJre));
        element.setAttribute(ALTERNATIVE_JRE_PATH, this.alternativeJrePath != null ? this.alternativeJrePath : "");
        element.setAttribute(FRAMEWORK_START_LEVEL, String.valueOf(this.frameworkStartLevel));
        element.setAttribute(DEFAULT_START_LEVEL, String.valueOf(this.defaultStartLevel));
        element.setAttribute(AUTO_START_LEVEL, String.valueOf(this.autoStartLevel));
        element.setAttribute(GENERATE_WORKING_DIR_ATTRIBUTE, String.valueOf(this.generateWorkingDir));
        for (SelectedBundle selectedBundle : this.bundlesToDeploy) {
            Element bundle = new Element(BUNDLE_ELEMENT);
            bundle.setAttribute(NAME_ATTRIBUTE, selectedBundle.getName());
            if (!selectedBundle.isModule()) {
                bundle.setAttribute(URL_ATTRIBUTE, selectedBundle.getBundleUrl());
            }
            bundle.setAttribute(START_LEVEL_ATTRIBUTE, String.valueOf(selectedBundle.getStartLevel()));
            bundle.setAttribute(TYPE_ATTRIBUTE, selectedBundle.getBundleType().name());
            bundle.setAttribute(START_AFTER_INSTALLATION_ATTRIBUTE, Boolean.toString(selectedBundle.isStartAfterInstallation()));
            element.addContent(bundle);
        }
        Element framework = new Element(FRAMEWORK_ELEMENT);
        framework.setAttribute(INSTANCE_ATTRIBUTE, this.instanceToUse != null ? this.instanceToUse.getName() : "");
        element.addContent(framework);
        Element additionalProperties = new Element(ADDITIONAL_PROPERTIES_ELEMENT);
        for (String additionalPropertyName : this.additionalProperties.keySet()) {
            additionalProperties.setAttribute(additionalPropertyName, this.additionalProperties.get(additionalPropertyName));
        }
        element.addContent(additionalProperties);
        super.writeExternal(element);
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new OsgiRunConfigurationEditor(this.getProject());
    }

    public JDOMExternalizable createRunnerSettings(ConfigurationInfoProvider configurationInfoProvider) {
        return null;
    }

    public SettingsEditor<JDOMExternalizable> getRunnerSettingsEditor(ProgramRunner runner) {
        return null;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/OsgiRunConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/run/OsgiRunConfiguration.getState must not be null");
        }
        return new OsgiRunState(executor, env, this, this.getProject(), ProjectRootManager.getInstance((Project)this.getProject()).getProjectJdk());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        String jrePath;
        if (this.legacyOsgiRunConfigurationLoader != null) {
            this.legacyOsgiRunConfigurationLoader.finishAfterModulesAreAvailable(this);
            this.legacyOsgiRunConfigurationLoader = null;
        }
        if (this.instanceToUse == null) {
            throw new RuntimeConfigurationError(OsmorcBundle.getTranslation("runconfiguration.no.instance.selected", new Object[0]));
        }
        if (this.isUseAlternativeJre() && ((jrePath = this.getAlternativeJrePath()) == null || jrePath.length() == 0 || !JavaSdkImpl.checkForJre((String)jrePath))) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.not.valid.error.message", (Object[])new Object[]{jrePath}));
        }
        if (this.checker != null) {
            this.checker.checkConfiguration(this);
        }
    }

    @NotNull
    public Module[] getModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (SelectedBundle selectedBundle : this.getBundlesToDeploy()) {
            if (!selectedBundle.isModule()) continue;
            modules.add(ModuleManager.getInstance((Project)this.getProject()).findModuleByName(selectedBundle.getName()));
        }
        Module[] moduleArray = modules.toArray(new Module[modules.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/run/OsgiRunConfiguration.getModules must not return null");
        }
        return moduleArray;
    }

    @NotNull
    public Map<String, String> getAdditionalProperties() {
        Map<String, String> map = Collections.unmodifiableMap(this.additionalProperties);
        if (map == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/run/OsgiRunConfiguration.getAdditionalProperties must not return null");
        }
        return map;
    }

    public String getAlternativeJrePath() {
        return this.alternativeJrePath;
    }

    @NotNull
    public List<SelectedBundle> getBundlesToDeploy() {
        List<SelectedBundle> list = this.bundlesToDeploy;
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/run/OsgiRunConfiguration.getBundlesToDeploy must not return null");
        }
        return list;
    }

    public int getFrameworkStartLevel() {
        return this.frameworkStartLevel;
    }

    @Nullable
    public FrameworkInstanceDefinition getInstanceToUse() {
        return this.instanceToUse;
    }

    public String getProgramParameters() {
        return this.programParameters != null ? this.programParameters : "";
    }

    @NotNull
    public String getVmParameters() {
        String string = this.vmParameters != null ? this.vmParameters : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/run/OsgiRunConfiguration.getVmParameters must not return null");
        }
        return string;
    }

    public String getWorkingDir() {
        return this.workingDir != null ? this.workingDir : "";
    }

    public boolean isAutoStartLevel() {
        return this.autoStartLevel;
    }

    public boolean isIncludeAllBundlesInClassPath() {
        return this.includeAllBundlesInClassPath;
    }

    public boolean isUseAlternativeJre() {
        return this.useAlternativeJre;
    }

    public void putAdditionalProperties(@NotNull Map<String, String> props) {
        if (props == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/OsgiRunConfiguration.putAdditionalProperties must not be null");
        }
        this.additionalProperties.putAll(props);
    }

    public void setAdditionalChecker(@Nullable OsgiRunConfigurationChecker checker) {
        this.checker = checker;
    }

    public void setAlternativeJrePath(String alternativeJrePath) {
        this.alternativeJrePath = alternativeJrePath;
    }

    public void setAutoStartLevel(boolean autoStartLevel) {
        this.autoStartLevel = autoStartLevel;
    }

    public void setBundlesToDeploy(List<SelectedBundle> bundlesToDeploy) {
        this.bundlesToDeploy = bundlesToDeploy;
    }

    public void setFrameworkStartLevel(int frameworkStartLevel) {
        this.frameworkStartLevel = frameworkStartLevel;
    }

    public void setIncludeAllBundlesInClassPath(boolean includeAllBundlesInClassPath) {
        this.includeAllBundlesInClassPath = includeAllBundlesInClassPath;
    }

    public void setInstanceToUse(@NotNull FrameworkInstanceDefinition instanceToUse) {
        if (instanceToUse == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/OsgiRunConfiguration.setInstanceToUse must not be null");
        }
        this.instanceToUse = instanceToUse;
    }

    public void setProgramParameters(String programParameters) {
        this.programParameters = programParameters;
    }

    public void setUseAlternativeJre(boolean useAlternativeJre) {
        this.useAlternativeJre = useAlternativeJre;
    }

    public void setVmParameters(String vmParameters) {
        this.vmParameters = vmParameters;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public int getDefaultStartLevel() {
        return this.defaultStartLevel;
    }

    public void setDefaultStartLevel(int defaultStartLevel) {
        this.defaultStartLevel = defaultStartLevel;
    }

    public boolean isGenerateWorkingDir() {
        return this.generateWorkingDir;
    }

    public void setGenerateWorkingDir(boolean generateWorkingDir) {
        this.generateWorkingDir = generateWorkingDir;
    }
}

