/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.ModuleChangeListener;
import org.osmorc.run.OsgiConfigurationType;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.SelectedBundle;

public class OsgiRunConfigurationModuleChangeListener
implements ModuleChangeListener {
    @NotNull
    private final OsgiConfigurationType configurationType;
    @NotNull
    private final Application application;

    public OsgiRunConfigurationModuleChangeListener(@NotNull OsgiConfigurationType configurationType, @NotNull Application application) {
        if (configurationType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/OsgiRunConfigurationModuleChangeListener.<init> must not be null");
        }
        if (application == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/run/OsgiRunConfigurationModuleChangeListener.<init> must not be null");
        }
        this.configurationType = configurationType;
        this.application = application;
    }

    public void moduleRenamed(final @NotNull Module module, @NotNull String oldName) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/OsgiRunConfigurationModuleChangeListener.moduleRenamed must not be null");
        }
        if (oldName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/run/OsgiRunConfigurationModuleChangeListener.moduleRenamed must not be null");
        }
        Project project = module.getProject();
        RunConfiguration[] runConfigurations = RunManager.getInstance((Project)project).getConfigurations((ConfigurationType)this.configurationType);
        if (runConfigurations != null) {
            block0: for (RunConfiguration runConfiguration : runConfigurations) {
                OsgiRunConfiguration osgiRunConfiguration = (OsgiRunConfiguration)runConfiguration;
                List<SelectedBundle> bundleList = osgiRunConfiguration.getBundlesToDeploy();
                for (final SelectedBundle selectedBundle : bundleList) {
                    if (!oldName.equals(selectedBundle.getName())) continue;
                    this.application.runWriteAction(new Runnable(){

                        public void run() {
                            selectedBundle.setName(module.getName());
                        }
                    });
                    continue block0;
                }
            }
        }
    }

    public void moduleRemoved(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/OsgiRunConfigurationModuleChangeListener.moduleRemoved must not be null");
        }
    }
}

