/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.DummyCompileContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.frameworkintegration.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.frameworkintegration.FrameworkRunner;
import org.osmorc.make.BundleCompiler;
import org.osmorc.run.ExternalVMFrameworkRunner;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.SelectedBundle;

public class OsgiRunState
extends JavaCommandLineState {
    private final OsgiRunConfiguration runConfiguration;
    private final Project project;
    private final Sdk jdkForRun;
    private SelectedBundle[] _selectedBundles;
    private final FrameworkRunner runner;
    private static final String FILE_URL_PREFIX = "file:///";

    public OsgiRunState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, OsgiRunConfiguration configuration, Project project, Sdk projectJdk) {
        String path;
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/OsgiRunState.<init> must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/run/OsgiRunState.<init> must not be null");
        }
        super(env);
        this.runConfiguration = configuration;
        this.project = project;
        this.jdkForRun = configuration.isUseAlternativeJre() ? ((path = configuration.getAlternativeJrePath()) == null || "".equals(path) || !JdkUtil.checkForJre((String)path) ? null : JavaSdk.getInstance().createJdk("", configuration.getAlternativeJrePath())) : projectJdk;
        this.setConsoleBuilder((TextConsoleBuilder)new TextConsoleBuilderImpl(project));
        FrameworkInstanceDefinition definition = this.runConfiguration.getInstanceToUse();
        FrameworkIntegratorRegistry registry = (FrameworkIntegratorRegistry)ServiceManager.getService((Project)project, FrameworkIntegratorRegistry.class);
        FrameworkIntegrator integrator = registry.findIntegratorByInstanceDefinition(definition);
        this.runner = integrator.createFrameworkRunner();
        this.runner.init(project, this.runConfiguration, this.getRunnerSettings());
    }

    public boolean requiresRemoteDebugger() {
        return this.runner instanceof ExternalVMFrameworkRunner;
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        SelectedBundle[] bundles;
        if (this.jdkForRun == null) {
            throw CantRunException.noJdkConfigured();
        }
        JavaParameters params = new JavaParameters();
        params.setWorkingDirectory(this.runner.getWorkingDir());
        params.configureByProject(this.project, 1, this.jdkForRun);
        PathsList classpath = params.getClassPath();
        for (VirtualFile libraryFile : this.runner.getFrameworkStarterLibraries()) {
            classpath.add(libraryFile);
        }
        if (this.runConfiguration.isIncludeAllBundlesInClassPath()) {
            for (SelectedBundle bundle : bundles = this.getSelectedBundles()) {
                String bundlePath = bundle.getBundleUrl();
                if ((bundlePath = bundlePath.substring(FILE_URL_PREFIX.length())).indexOf(58) < 0 && bundlePath.charAt(0) != '/') {
                    bundlePath = "/" + bundlePath;
                }
                bundlePath = bundlePath.replace('/', File.separatorChar);
                classpath.add(bundlePath);
            }
        }
        params.setMainClass(this.runner.getMainClass());
        bundles = this.getSelectedBundles();
        if (bundles == null) {
            throw new CantRunException("One or more modules seem to be missing their OSGi facets. Please re-add the OSGi facets and try again.");
        }
        ParametersList programParameters = params.getProgramParametersList();
        this.runner.fillCommandLineParameters(programParameters, bundles);
        ParametersList vmParameters = params.getVMParametersList();
        this.runner.fillVmParameters(vmParameters, bundles);
        return params;
    }

    @Nullable
    private SelectedBundle[] getSelectedBundles() {
        if (this._selectedBundles == null) {
            ProgressManager.getInstance().run((Task)new Task.Modal(this.project, "Preparing bundles...", false){

                public void run(@NotNull ProgressIndicator progressIndicator) {
                    if (progressIndicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/OsgiRunState$1.run must not be null");
                    }
                    progressIndicator.setIndeterminate(false);
                    HashSet<SelectedBundle> selectedBundles = new HashSet<SelectedBundle>();
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)OsgiRunState.this.project);
                    int bundleCount = OsgiRunState.this.runConfiguration.getBundlesToDeploy().size();
                    for (int i = 0; i < bundleCount; ++i) {
                        final SelectedBundle selectedBundle = OsgiRunState.this.runConfiguration.getBundlesToDeploy().get(i);
                        progressIndicator.setFraction((double)(i / bundleCount));
                        if (selectedBundle.isModule()) {
                            try {
                                String[] depUrls;
                                Module module = moduleManager.findModuleByName(selectedBundle.getName());
                                if (!OsmorcFacet.hasOsmorcFacet(module)) {
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            public void run() {
                                                Messages.showErrorDialog((String)("Module '" + selectedBundle.getName() + "' has no OSGi facet, but should have. Please re-add the OSGi facet to this module."), (String)"Error");
                                            }
                                        });
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    OsgiRunState.access$202(OsgiRunState.this, null);
                                    return;
                                }
                                selectedBundle.setBundleUrl(new URL("file", "/", BundleCompiler.getJarFileName(module)).toString());
                                for (String depUrl : depUrls = BundleCompiler.bundlifyLibraries(module, progressIndicator, (CompileContext)DummyCompileContext.getInstance())) {
                                    SelectedBundle dependency = new SelectedBundle("Dependency", depUrl, SelectedBundle.BundleType.PlainLibrary);
                                    selectedBundles.add(dependency);
                                }
                                selectedBundles.add(selectedBundle);
                                continue;
                            }
                            catch (MalformedURLException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                        if (selectedBundles.contains(selectedBundle)) {
                            selectedBundles.remove(selectedBundle);
                        }
                        selectedBundles.add(selectedBundle);
                    }
                    HashMap<String, SelectedBundle> finalList = new HashMap<String, SelectedBundle>();
                    for (SelectedBundle selectedBundle : selectedBundles) {
                        String name = CachingBundleInfoProvider.getBundleSymbolicName(selectedBundle.getBundleUrl());
                        String version = CachingBundleInfoProvider.getBundleVersions(selectedBundle.getBundleUrl());
                        String key = name + version;
                        if (finalList.containsKey(key)) continue;
                        finalList.put(key, selectedBundle);
                    }
                    Collection selectedBundleCollection = finalList.values();
                    OsgiRunState.access$202(OsgiRunState.this, selectedBundleCollection.toArray(new SelectedBundle[selectedBundleCollection.size()]));
                    Arrays.sort(OsgiRunState.this._selectedBundles, new StartLevelComparator());
                }
            });
        }
        return this._selectedBundles;
    }

    protected OSProcessHandler startProcess() throws ExecutionException {
        SelectedBundle[] bundles = this.getSelectedBundles();
        this.runner.runCustomInstallationSteps(bundles);
        OSProcessHandler handler = super.startProcess();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                Disposer.dispose((Disposable)OsgiRunState.this.runner);
            }
        });
        return handler;
    }

    static /* synthetic */ SelectedBundle[] access$202(OsgiRunState x0, SelectedBundle[] x1) {
        x0._selectedBundles = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartLevelComparator
    implements Comparator<SelectedBundle> {
        @Override
        public int compare(SelectedBundle selectedBundle, SelectedBundle selectedBundle2) {
            return selectedBundle.getStartLevel() - selectedBundle2.getStartLevel();
        }
    }
}

