/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.managingbundle;

import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osmorc.run.managingbundle.ManagingBundle;
import org.osmorc.run.managingbundle.ManagingBundleImpl;

public class ManagingBundleActivator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        try {
            String name = ManagingBundle.class.getName();
            ManagingBundleImpl implementation = new ManagingBundleImpl(context);
            ManagingBundle stub = (ManagingBundle)UnicastRemoteObject.exportObject((Remote)implementation, 0);
            Registry registry = LocateRegistry.getRegistry();
            registry.rebind(name, stub);
        }
        catch (Exception e) {
            System.err.println("Problem when trying to register the ManagingBundle:");
            e.printStackTrace();
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            Registry registry = LocateRegistry.getRegistry();
            registry.unbind(ManagingBundle.class.getName());
        }
        catch (Exception e) {
            System.err.println("Problem when trying to unregister the ManagingBundle:");
            e.printStackTrace();
        }
    }
}

