/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.frameworkintegration.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.LibraryHandler;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.make.BundleCompiler;
import org.osmorc.run.ui.SelectedBundle;
import org.osmorc.run.ui.SelectedBundleListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleSelector
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JList bundlesList;
    private JTextField searchField;
    private FrameworkInstanceDefinition usedFramework;
    private List<SelectedBundle> hideBundles;
    private final Project project;
    private ArrayList<SelectedBundle> selectedBundles;
    private ArrayList<SelectedBundle> allAvailableBundles;

    public BundleSelector(Project project) {
        this.$$$setupUI$$$();
        this.hideBundles = new ArrayList<SelectedBundle>();
        this.selectedBundles = new ArrayList();
        this.allAvailableBundles = new ArrayList();
        this.project = project;
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.setTitle(OsmorcBundle.getTranslation("bundleselector.title", new Object[0]));
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.bundlesList.setCellRenderer(new SelectedBundleListCellRenderer());
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BundleSelector.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BundleSelector.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BundleSelector.this.onCancel();
            }
        });
        this.searchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                BundleSelector.this.updateList();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BundleSelector.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.bundlesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BundleSelector.this.buttonOK.setEnabled(BundleSelector.this.bundlesList.getSelectedIndex() != -1);
            }
        });
        this.setSize(400, 300);
    }

    public void show(JComponent owner) {
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void createList() {
        Module[] modules;
        this.allAvailableBundles.clear();
        HashSet<SelectedBundle> hs = new HashSet<SelectedBundle>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.project).getModules()) {
            if (!OsmorcFacet.hasOsmorcFacet(module)) continue;
            SelectedBundle selectedBundle = new SelectedBundle(module.getName(), null, SelectedBundle.BundleType.Module);
            hs.add(selectedBundle);
        }
        if (this.usedFramework != null) {
            LibraryHandler libraryHandler = (LibraryHandler)ServiceManager.getService(LibraryHandler.class);
            List<Library> libs = libraryHandler.getLibraries(this.usedFramework.getName());
            for (Library lib : libs) {
                String[] urls;
                for (String url : urls = lib.getUrls(OrderRootType.CLASSES)) {
                    url = BundleCompiler.convertJarUrlToFileUrl(url);
                    String bundleName = CachingBundleInfoProvider.getBundleSymbolicName(url = BundleCompiler.fixFileURL(url));
                    if (bundleName == null) continue;
                    String bundleVersion = CachingBundleInfoProvider.getBundleVersions(url);
                    SelectedBundle b = new SelectedBundle(bundleName + " - " + bundleVersion, url, SelectedBundle.BundleType.FrameworkBundle);
                    hs.add(b);
                }
            }
            for (Module module : modules) {
                OrderEntry[] entries;
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
                ModifiableRootModel model = manager.getModifiableModel();
                for (OrderEntry entry : entries = model.getOrderEntries()) {
                    String[] urls;
                    if (entry instanceof JdkOrderEntry || entry instanceof LibraryOrderEntry && libraryHandler.isFrameworkInstanceLibrary((LibraryOrderEntry)entry)) continue;
                    for (String url : urls = entry.getUrls(OrderRootType.CLASSES)) {
                        url = BundleCompiler.convertJarUrlToFileUrl(url);
                        String displayName = CachingBundleInfoProvider.getBundleSymbolicName(url = BundleCompiler.fixFileURL(url));
                        if (displayName == null) continue;
                        SelectedBundle selectedBundle = new SelectedBundle(displayName, url, SelectedBundle.BundleType.StartableLibrary);
                        hs.add(selectedBundle);
                    }
                }
                model.dispose();
            }
        }
        hs.removeAll(this.hideBundles);
        this.allAvailableBundles.addAll(hs);
        Collections.sort(this.allAvailableBundles, new TypeComparator());
    }

    private void updateList() {
        ArrayList<SelectedBundle> theList = new ArrayList<SelectedBundle>(this.allAvailableBundles);
        String filterText = this.searchField.getText().toLowerCase();
        DefaultListModel<SelectedBundle> newModel = new DefaultListModel<SelectedBundle>();
        for (SelectedBundle selectedBundle : theList) {
            boolean needsFiltering;
            boolean bl = needsFiltering = filterText.length() > 0;
            if (needsFiltering && !selectedBundle.getName().toLowerCase().contains(filterText)) continue;
            newModel.addElement(selectedBundle);
        }
        this.bundlesList.setModel(newModel);
    }

    private void onOK() {
        Object[] selectedValues = this.bundlesList.getSelectedValues();
        this.selectedBundles = new ArrayList();
        for (Object selectedValue : selectedValues) {
            this.selectedBundles.add((SelectedBundle)selectedValue);
        }
        this.dispose();
    }

    private void onCancel() {
        this.selectedBundles = null;
        this.dispose();
    }

    public void setUp(@Nullable FrameworkInstanceDefinition usedFramework, @NotNull List<SelectedBundle> hideBundles) {
        if (hideBundles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/run/ui/BundleSelector.setUp must not be null");
        }
        this.usedFramework = usedFramework;
        this.hideBundles = hideBundles;
        this.createList();
        this.updateList();
    }

    @Nullable
    public List<SelectedBundle> getSelectedBundles() {
        return this.selectedBundles;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JList jList;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("ok"));
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("cancel"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel4.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.bundlesList = jList = new JList();
        jScrollPane.setViewportView(jList);
        this.searchField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/general/toolWindowFind.png")));
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeComparator
    implements Comparator<SelectedBundle> {
        @Override
        public int compare(SelectedBundle selectedBundle, SelectedBundle selectedBundle2) {
            return selectedBundle.getBundleType().ordinal() - selectedBundle2.getBundleType().ordinal();
        }
    }
}

