/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class IntegerEditor
extends DefaultCellEditor {
    JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
    NumberFormat integerFormat;
    private Integer minimum;
    private Integer maximum;
    private boolean DEBUG = false;

    public IntegerEditor(int min, int max) {
        super(new JFormattedTextField());
        this.minimum = new Integer(min);
        this.maximum = new Integer(max);
        this.integerFormat = NumberFormat.getIntegerInstance();
        NumberFormatter intFormatter = new NumberFormatter(this.integerFormat);
        intFormatter.setFormat(this.integerFormat);
        intFormatter.setMinimum(this.minimum);
        intFormatter.setMaximum(this.maximum);
        this.ftf.setFormatterFactory(new DefaultFormatterFactory(intFormatter));
        this.ftf.setValue(this.minimum);
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFocusLostBehavior(3);
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.ftf.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!IntegerEditor.this.ftf.isEditValid()) {
                    if (IntegerEditor.this.userSaysRevert()) {
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                } else {
                    try {
                        IntegerEditor.this.ftf.commitEdit();
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setValue(value);
        return ftf;
    }

    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Integer) {
            return o;
        }
        if (o instanceof Number) {
            return new Integer(((Number)o).intValue());
        }
        if (this.DEBUG) {
            System.out.println("getCellEditorValue: o isn't a Number");
        }
        try {
            return this.integerFormat.parseObject(o.toString());
        }
        catch (ParseException exc) {
            System.err.println("getCellEditorValue: can't parse o: " + o);
            return null;
        }
    }

    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else if (!this.userSaysRevert()) {
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean userSaysRevert() {
        Toolkit.getDefaultToolkit().beep();
        this.ftf.selectAll();
        Object[] options = new Object[]{"Edit", "Revert"};
        int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), "The value must be an integer between " + this.minimum + " and " + this.maximum + ".\n" + "You can either continue editing " + "or revert to the last valid value.", "Invalid Text Entered", 0, 0, null, options, options[1]);
        if (answer == 1) {
            this.ftf.setValue(this.ftf.getValue());
            return true;
        }
        return false;
    }
}

