/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class JSpinnerCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    final JSpinner spinner = new JSpinner();

    public JSpinnerCellEditor() {
        this.spinner.setModel(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.spinner.setValue(value);
        table.setRowHeight(row, this.spinner.getPreferredSize().height);
        this.spinner.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                JSpinnerCellEditor.this.fireEditingStopped();
            }
        });
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSpinnerCellEditor.this.fireEditingStopped();
            }
        });
        return this.spinner;
    }

    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= 1;
        }
        return true;
    }

    public Object getCellEditorValue() {
        return this.spinner.getValue();
    }

    public boolean stopCellEditing() {
        try {
            this.spinner.commitEdit();
        }
        catch (ParseException exc) {
            return false;
        }
        return super.stopCellEditing();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.spinner.setValue(value);
        table.setRowHeight(row, this.spinner.getPreferredSize().height);
        return this.spinner;
    }
}

