/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.BundleSelectionAction;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.OsgiRunConfigurationChecker;
import org.osmorc.run.OsgiRunConfigurationCheckerProvider;
import org.osmorc.run.ui.BundleSelector;
import org.osmorc.run.ui.FrameworkRunPropertiesEditor;
import org.osmorc.run.ui.JSpinnerCellEditor;
import org.osmorc.run.ui.SelectedBundle;
import org.osmorc.settings.ApplicationSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiRunConfigurationEditor
extends SettingsEditor<OsgiRunConfiguration>
implements BundleSelectionAction.Context {
    private final DefaultActionGroup frameworkSpecificBundleSelectionActions;
    private OsgiRunConfiguration osgiRunConfiguration;
    private RawCommandLineEditor vmParams;
    private JButton addButton;
    private JButton removeButton;
    private JComboBox frameworkInstances;
    private JPanel additionalFrameworkPropertiesPanel;
    private JTable modulesList;
    private JTabbedPane root;
    private JCheckBox includeAllBundlesinClassPath;
    private JRadioButton osmorcControlledRadioButton;
    private JRadioButton userDefinedRadioButton;
    private TextFieldWithBrowseButton workingDirField;
    private RawCommandLineEditor programParameters;
    private JButton frameworkSpecificButton;
    private AlternativeJREPanel alternativeJREPanel;
    private JSpinner myFrameworkStartLevel;
    private JCheckBox myAutomaticStartLevel;
    private JSpinner myDefaultStartLevel;
    private final Project project;
    private FrameworkRunPropertiesEditor currentFrameworkRunPropertiesEditor;

    public OsgiRunConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        ApplicationSettings registry = (ApplicationSettings)ServiceManager.getService(ApplicationSettings.class);
        DefaultComboBoxModel<Object> cbmodel = new DefaultComboBoxModel<Object>(registry.getFrameworkInstanceDefinitions().toArray());
        this.frameworkInstances.setModel(cbmodel);
        this.frameworkInstances.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsgiRunConfigurationEditor.this.onFrameworkChange();
            }
        });
        this.project = project;
        RunConfigurationTableModel model = new RunConfigurationTableModel();
        this.modulesList.setModel(model);
        this.modulesList.setRowSelectionAllowed(true);
        this.modulesList.setColumnSelectionAllowed(false);
        this.modulesList.setDefaultEditor(Integer.class, new JSpinnerCellEditor());
        this.modulesList.setDefaultRenderer(Integer.class, new JSpinnerCellEditor());
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsgiRunConfigurationEditor.this.onAddClick();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsgiRunConfigurationEditor.this.onRemoveClick();
            }
        });
        this.osmorcControlledRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean isUserDefined = !OsgiRunConfigurationEditor.this.osmorcControlledRadioButton.isSelected();
                OsgiRunConfigurationEditor.this.workingDirField.setEnabled(isUserDefined);
            }
        });
        this.workingDirField.addBrowseFolderListener("Choose a working directory", "The working directory is the directory from which the framework is started", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.workingDirField.getTextField().setColumns(30);
        this.frameworkSpecificBundleSelectionActions = new DefaultActionGroup("frameworkSpecificBundleSelectionActions", true);
        this.myAutomaticStartLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsgiRunConfigurationEditor.this.myFrameworkStartLevel.setEnabled(!OsgiRunConfigurationEditor.this.myAutomaticStartLevel.isSelected());
            }
        });
        this.frameworkSpecificButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)OsgiRunConfigurationEditor.this.frameworkSpecificBundleSelectionActions, DataManager.getInstance().getDataContext((Component)OsgiRunConfigurationEditor.this.frameworkSpecificButton), JBPopupFactory.ActionSelectionAid.NUMBERING, true).showUnderneathOf((Component)OsgiRunConfigurationEditor.this.frameworkSpecificButton);
            }
        });
        this.modulesList.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int width = OsgiRunConfigurationEditor.this.modulesList.getWidth();
                int bundleNameWidth = 2 * width / 3;
                int otherWidth = width / 3 / 2;
                TableColumn bundleColumn = OsgiRunConfigurationEditor.this.modulesList.getColumnModel().getColumn(0);
                bundleColumn.setPreferredWidth(bundleNameWidth);
                TableColumn startLevelColumn = OsgiRunConfigurationEditor.this.modulesList.getColumnModel().getColumn(1);
                startLevelColumn.setPreferredWidth(otherWidth);
                TableColumn startColumn = OsgiRunConfigurationEditor.this.modulesList.getColumnModel().getColumn(2);
                startColumn.setPreferredWidth(otherWidth);
            }
        });
    }

    private void onFrameworkChange() {
        this.frameworkSpecificBundleSelectionActions.removeAll();
        if (this.frameworkInstances.getSelectedItem() != null) {
            FrameworkInstanceDefinition frameworkInstanceDefinition = (FrameworkInstanceDefinition)this.frameworkInstances.getSelectedItem();
            FrameworkIntegratorRegistry registry = (FrameworkIntegratorRegistry)ServiceManager.getService(FrameworkIntegratorRegistry.class);
            FrameworkIntegrator integrator = registry.findIntegratorByInstanceDefinition(frameworkInstanceDefinition);
            this.additionalFrameworkPropertiesPanel.removeAll();
            this.currentFrameworkRunPropertiesEditor = integrator.createRunPropertiesEditor();
            if (this.currentFrameworkRunPropertiesEditor != null) {
                this.additionalFrameworkPropertiesPanel.removeAll();
                this.additionalFrameworkPropertiesPanel.add((Component)this.currentFrameworkRunPropertiesEditor.getUI(), "Center");
                if (this.osgiRunConfiguration != null) {
                    this.currentFrameworkRunPropertiesEditor.resetEditorFrom(this.osgiRunConfiguration);
                    OsgiRunConfigurationChecker checker = null;
                    if (integrator instanceof OsgiRunConfigurationCheckerProvider) {
                        checker = ((OsgiRunConfigurationCheckerProvider)((Object)integrator)).getOsgiRunConfigurationChecker();
                    }
                    this.osgiRunConfiguration.setAdditionalChecker(checker);
                }
            }
            RunConfigurationTableModel model = this.getTableModel();
            model.removeAllOfType(SelectedBundle.BundleType.FrameworkBundle);
            for (BundleSelectionAction bundleSelectionAction : integrator.getBundleSelectionActions()) {
                bundleSelectionAction.setContext(this);
                this.frameworkSpecificBundleSelectionActions.add((AnAction)bundleSelectionAction);
            }
        }
    }

    private void onRemoveClick() {
        int[] indices = this.modulesList.getSelectedRows();
        RunConfigurationTableModel model = this.getTableModel();
        for (int i = indices.length - 1; i >= 0; --i) {
            model.removeBundleAt(indices[i]);
        }
    }

    private RunConfigurationTableModel getTableModel() {
        return (RunConfigurationTableModel)this.modulesList.getModel();
    }

    private void onAddClick() {
        BundleSelector selector = new BundleSelector(this.project);
        selector.setUp((FrameworkInstanceDefinition)this.frameworkInstances.getSelectedItem(), this.getBundlesToRun());
        selector.show(this.root);
        List<SelectedBundle> selectedModules = selector.getSelectedBundles();
        if (selectedModules != null) {
            RunConfigurationTableModel model = this.getTableModel();
            for (SelectedBundle aModule : selectedModules) {
                model.addBundle(aModule);
            }
        }
    }

    @Override
    @NotNull
    public List<SelectedBundle> getCurrentlySelectedBundles() {
        List<SelectedBundle> list = this.getBundlesToRun();
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/run/ui/OsgiRunConfigurationEditor.getCurrentlySelectedBundles must not return null");
        }
        return list;
    }

    @Override
    public void addBundle(@NotNull SelectedBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/ui/OsgiRunConfigurationEditor.addBundle must not be null");
        }
        this.getTableModel().addBundle(bundle);
    }

    @Override
    public void removeBundle(@NotNull SelectedBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/ui/OsgiRunConfigurationEditor.removeBundle must not be null");
        }
        this.getTableModel().removeBundle(bundle);
    }

    @Override
    @Nullable
    public FrameworkInstanceDefinition getUsedFrameworkInstance() {
        return (FrameworkInstanceDefinition)this.frameworkInstances.getSelectedItem();
    }

    protected void resetEditorFrom(OsgiRunConfiguration osgiRunConfiguration) {
        VirtualFilePointer outputDirPointer;
        CompilerProjectExtension extension;
        this.osgiRunConfiguration = osgiRunConfiguration;
        this.vmParams.setText(osgiRunConfiguration.getVmParameters());
        this.programParameters.setText(osgiRunConfiguration.getProgramParameters());
        this.frameworkInstances.setSelectedItem(osgiRunConfiguration.getInstanceToUse());
        this.includeAllBundlesinClassPath.setSelected(osgiRunConfiguration.isIncludeAllBundlesInClassPath());
        if (this.currentFrameworkRunPropertiesEditor != null) {
            this.currentFrameworkRunPropertiesEditor.resetEditorFrom(osgiRunConfiguration);
        }
        List<SelectedBundle> modules = osgiRunConfiguration.getBundlesToDeploy();
        RunConfigurationTableModel model = this.getTableModel();
        while (model.getRowCount() > 0) {
            model.removeBundleAt(0);
        }
        for (SelectedBundle module : modules) {
            model.addBundle(module);
        }
        this.modulesList.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.myAutomaticStartLevel.setSelected(osgiRunConfiguration.isAutoStartLevel());
        this.myFrameworkStartLevel.setValue(osgiRunConfiguration.getFrameworkStartLevel());
        this.myFrameworkStartLevel.setEnabled(!this.myAutomaticStartLevel.isSelected());
        this.myDefaultStartLevel.setValue(osgiRunConfiguration.getDefaultStartLevel());
        boolean useUserDefinedFields = !osgiRunConfiguration.isGenerateWorkingDir();
        this.workingDirField.setText(osgiRunConfiguration.getWorkingDir());
        if (this.workingDirField.getText().length() == 0 && (extension = CompilerProjectExtension.getInstance((Project)this.project)) != null && (outputDirPointer = extension.getCompilerOutputPointer()) != null) {
            this.workingDirField.setText(VfsUtil.urlToPath((String)(outputDirPointer.getUrl() + "/run.osgi/")));
        }
        this.workingDirField.setEnabled(useUserDefinedFields);
        this.userDefinedRadioButton.setSelected(useUserDefinedFields);
        this.osmorcControlledRadioButton.setSelected(!useUserDefinedFields);
        this.alternativeJREPanel.init(osgiRunConfiguration.getAlternativeJrePath(), osgiRunConfiguration.isUseAlternativeJre());
    }

    protected void applyEditorTo(OsgiRunConfiguration osgiRunConfiguration) throws ConfigurationException {
        List<SelectedBundle> modules = this.getBundlesToRun();
        osgiRunConfiguration.setBundlesToDeploy(modules);
        osgiRunConfiguration.setVmParameters(this.vmParams.getText());
        osgiRunConfiguration.setProgramParameters(this.programParameters.getText());
        osgiRunConfiguration.setIncludeAllBundlesInClassPath(this.includeAllBundlesinClassPath.isSelected());
        osgiRunConfiguration.setWorkingDir(this.workingDirField.getText().replace('\\', '/'));
        osgiRunConfiguration.setUseAlternativeJre(this.alternativeJREPanel.isPathEnabled());
        osgiRunConfiguration.setAlternativeJrePath(this.alternativeJREPanel.getPath());
        osgiRunConfiguration.setFrameworkStartLevel((Integer)this.myFrameworkStartLevel.getValue());
        osgiRunConfiguration.setDefaultStartLevel((Integer)this.myDefaultStartLevel.getValue());
        osgiRunConfiguration.setAutoStartLevel(this.myAutomaticStartLevel.isSelected());
        osgiRunConfiguration.setGenerateWorkingDir(this.osmorcControlledRadioButton.isSelected());
        FrameworkInstanceDefinition frameworkInstanceDefinition = (FrameworkInstanceDefinition)this.frameworkInstances.getSelectedItem();
        if (frameworkInstanceDefinition != null) {
            osgiRunConfiguration.setInstanceToUse(frameworkInstanceDefinition);
        }
        if (this.currentFrameworkRunPropertiesEditor != null) {
            this.currentFrameworkRunPropertiesEditor.applyEditorTo(osgiRunConfiguration);
        }
    }

    private List<SelectedBundle> getBundlesToRun() {
        return this.getTableModel().getBundles();
    }

    @NotNull
    protected JComponent createEditor() {
        JTabbedPane jTabbedPane = this.root;
        if (jTabbedPane == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/run/ui/OsgiRunConfigurationEditor.createEditor must not return null");
        }
        return jTabbedPane;
    }

    protected void disposeEditor() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        AlternativeJREPanel alternativeJREPanel;
        RawCommandLineEditor rawCommandLineEditor;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        RawCommandLineEditor rawCommandLineEditor2;
        JSpinner jSpinner;
        JCheckBox jCheckBox2;
        JSpinner jSpinner2;
        JComboBox jComboBox;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JTable jTable;
        JTabbedPane jTabbedPane;
        this.root = jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:p:noGrow,left:5dlu:noGrow,fill:103px:grow,fill:p:noGrow,left:4dlu:noGrow,fill:d:noGrow", "center:max(d;4px):noGrow,top:3dlu:noGrow,fill:d:noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):grow"));
        jPanel2.setMinimumSize(new Dimension(500, 200));
        jTabbedPane.addTab("Framework & Bundles", null, jPanel2, null);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), null, 0, 0, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new CellConstraints(1, 3, 4, 7, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.modulesList = jTable = new JTable();
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.putClientProperty("JTable.autoStartsEdit", new Boolean(false));
        jTable.putClientProperty("Table.isFileList", new Boolean(false));
        jScrollPane.setViewportView(jTable);
        this.addButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("add"));
        jButton3.setHorizontalAlignment(0);
        jPanel2.add((Component)jButton3, new CellConstraints(6, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.removeButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("remove"));
        ((Component)jButton2).setEnabled(true);
        jPanel2.add((Component)jButton2, new CellConstraints(6, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.frameworkSpecificButton = jButton = new JButton();
        jButton.setText("Presets...");
        jPanel2.add((Component)jButton, new CellConstraints(6, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:p:noGrow,left:4dlu:noGrow,fill:max(p;160px):noGrow,left:4dlu:noGrow,fill:p:noGrow,left:4dlu:noGrow,fill:max(d;80px):noGrow,left:4dlu:noGrow,fill:p:noGrow,left:5dlu:noGrow,fill:p:noGrow,fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:max(d;80px):noGrow,left:4dlu:grow", "center:max(d;4px):noGrow"));
        jPanel2.add((Component)jPanel3, new CellConstraints(1, 1, 6, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("osgi.framework"));
        jPanel3.add((Component)jLabel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Framework Start Level");
        jPanel3.add((Component)jLabel2, new CellConstraints(5, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.frameworkInstances = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myFrameworkStartLevel = jSpinner2 = new JSpinner();
        jPanel3.add((Component)jSpinner2, new CellConstraints(7, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myAutomaticStartLevel = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Auto");
        jPanel3.add((Component)jCheckBox2, new CellConstraints(9, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Default Start Level:");
        jPanel3.add((Component)jLabel3, new CellConstraints(12, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myDefaultStartLevel = jSpinner = new JSpinner();
        jPanel3.add((Component)jSpinner, new CellConstraints(14, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new FormLayout("fill:d:grow,left:4dlu:noGrow,fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:max(d;4px):noGrow", "center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        jTabbedPane.addTab("Parameters", null, jPanel4, null);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), null, 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("setup.vm.parameters"));
        jPanel4.add((Component)jLabel4, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.vmParams = rawCommandLineEditor2 = new RawCommandLineEditor();
        rawCommandLineEditor2.setDialogCaption("VM Parameters");
        jPanel4.add((Component)rawCommandLineEditor2, new CellConstraints(1, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.includeAllBundlesinClassPath = jCheckBox = new JCheckBox();
        jCheckBox.setText("Include all bundles in class path");
        jPanel4.add((Component)jCheckBox, new CellConstraints(1, 11, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new CellConstraints(1, 13, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Runtime Directory", 0, 0, null, null));
        this.osmorcControlledRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Recreate each time ");
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.userDefinedRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use this directory");
        jPanel5.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.workingDirField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Program Parameters");
        jPanel4.add((Component)jLabel5, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.programParameters = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("Program Parameters");
        jPanel4.add((Component)rawCommandLineEditor, new CellConstraints(1, 7, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.alternativeJREPanel = alternativeJREPanel = new AlternativeJREPanel();
        jPanel4.add((Component)alternativeJREPanel, new CellConstraints(1, 9, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.additionalFrameworkPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jTabbedPane.addTab("Additional Framework Properties", null, jPanel, null);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), null, 0, 0, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RunConfigurationTableModel
    extends AbstractTableModel {
        private final List<SelectedBundle> selectedBundles = new ArrayList<SelectedBundle>();

        public SelectedBundle getBundleAt(int index) {
            return this.selectedBundles.get(index);
        }

        public List<SelectedBundle> getBundles() {
            return this.selectedBundles;
        }

        public void removeBundle(SelectedBundle bundle) {
            this.removeBundleAt(this.selectedBundles.indexOf(bundle));
        }

        public void removeBundleAt(int index) {
            this.selectedBundles.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void addBundle(SelectedBundle bundle) {
            this.selectedBundles.add(bundle);
            this.fireTableRowsInserted(this.selectedBundles.size() - 1, this.selectedBundles.size() - 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Bundle Name";
                }
                case 1: {
                    return "Start Level";
                }
                case 2: {
                    return "Start After Install";
                }
            }
            return "";
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.selectedBundles.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            SelectedBundle bundle = this.getBundleAt(row);
            switch (column) {
                case 1: {
                    bundle.setStartLevel((Integer)o);
                    break;
                }
                case 2: {
                    bundle.setStartAfterInstallation((Boolean)o);
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot edit column " + column);
                }
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            SelectedBundle bundle = this.getBundleAt(row);
            switch (column) {
                case 0: {
                    return bundle.toString();
                }
                case 1: {
                    return bundle.getStartLevel();
                }
                case 2: {
                    return bundle.isStartAfterInstallation();
                }
            }
            throw new RuntimeException("Don't know column " + column);
        }

        public void removeAllOfType(SelectedBundle.BundleType type) {
            Iterator<SelectedBundle> selectedBundleIterator = this.selectedBundles.iterator();
            while (selectedBundleIterator.hasNext()) {
                SelectedBundle selectedBundle = selectedBundleIterator.next();
                if (selectedBundle.getBundleType() != type) continue;
                selectedBundleIterator.remove();
            }
            this.fireTableDataChanged();
        }
    }
}

