/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedBundle {
    private String displayName;
    @Nullable
    private String bundleUrl;
    private int startLevel;
    private boolean startAfterInstallation;
    private BundleType bundleType;

    public SelectedBundle(@NotNull String displayName, @Nullable String url, @NotNull BundleType bundleType) {
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/ui/SelectedBundle.<init> must not be null");
        }
        if (bundleType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/run/ui/SelectedBundle.<init> must not be null");
        }
        this.displayName = displayName;
        this.bundleUrl = url;
        this.bundleType = bundleType;
        this.startAfterInstallation = bundleType.isDefaultStartAfterInstallation();
        this.startLevel = 1;
    }

    @NotNull
    public String getName() {
        String string = this.displayName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/run/ui/SelectedBundle.getName must not return null");
        }
        return string;
    }

    public void setName(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/run/ui/SelectedBundle.setName must not be null");
        }
        this.displayName = displayName;
    }

    @Nullable
    public String getBundleUrl() {
        return this.bundleUrl;
    }

    public String toString() {
        return this.displayName + (this.bundleUrl != null ? " (" + this.bundleUrl.substring(this.bundleUrl.lastIndexOf("/") + 1) + ")" : "");
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SelectedBundle) {
            SelectedBundle other = (SelectedBundle)o;
            return this.isModule() ? this.isEqual(this.displayName, other.displayName) : this.isEqual(this.bundleUrl, other.bundleUrl);
        }
        return false;
    }

    public int hashCode() {
        return this.isModule() ? this.displayName.hashCode() : (this.bundleUrl != null ? this.bundleUrl.hashCode() : 0);
    }

    private boolean isEqual(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2) && o2.equals(o1);
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public void setBundleUrl(@Nullable String bundleUrl) {
        this.bundleUrl = bundleUrl;
    }

    public BundleType getBundleType() {
        return this.bundleType;
    }

    public void setBundleType(BundleType bundleType) {
        this.bundleType = bundleType;
    }

    public boolean isModule() {
        return this.bundleType == BundleType.Module;
    }

    public boolean isStartAfterInstallation() {
        return this.startAfterInstallation;
    }

    public void setStartAfterInstallation(boolean startAfterInstallation) {
        this.startAfterInstallation = startAfterInstallation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BundleType {
        Module(true),
        FrameworkBundle(true),
        StartableLibrary(true),
        PlainLibrary(false);

        private final boolean defaultStartAfterInstallation;

        private BundleType(boolean startAfterInstallation) {
            this.defaultStartAfterInstallation = startAfterInstallation;
        }

        public boolean isDefaultStartAfterInstallation() {
            return this.defaultStartAfterInstallation;
        }
    }
}

