/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import com.intellij.util.Icons;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.ui.SelectedBundle;

public class SelectedBundleListCellRenderer
extends DefaultListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        SelectedBundle selectedBundle = (SelectedBundle)value;
        if (selectedBundle.isModule()) {
            component.setIcon(Icons.OPENED_MODULE_GROUP_ICON);
        } else if (selectedBundle.getBundleType() == SelectedBundle.BundleType.FrameworkBundle) {
            component.setIcon(OsmorcBundle.getSmallIcon());
        } else {
            component.setIcon(Icons.JAR_ICON);
        }
        component.setText(value.toString());
        return component;
    }
}

