/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.LibraryBundlificationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@State(name="Osmorc", storages={@Storage(id="Osmorc", file="$APP_CONFIG$/osmorc.xml")})
public class ApplicationSettings
implements PersistentStateComponent<ApplicationSettings> {
    private List<FrameworkInstanceDefinition> _frameworkInstanceDefinitions = new ArrayList<FrameworkInstanceDefinition>();
    private List<LibraryBundlificationRule> _libraryBundlificationRules = new ArrayList<LibraryBundlificationRule>();
    private EventDispatcher<ApplicationSettingsListener> dispatcher = EventDispatcher.create(ApplicationSettingsListener.class);

    public static ApplicationSettings getInstance() {
        return (ApplicationSettings)ServiceManager.getService(ApplicationSettings.class);
    }

    public ApplicationSettings() {
        this._libraryBundlificationRules.add(new LibraryBundlificationRule());
    }

    public ApplicationSettings getState() {
        return this;
    }

    public void loadState(ApplicationSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public void addFrameworkInstanceDefinition(FrameworkInstanceDefinition frameworkInstanceDefinition) {
        this._frameworkInstanceDefinitions.add(frameworkInstanceDefinition);
    }

    @Nullable
    public FrameworkInstanceDefinition getFrameworkInstance(@Nullable String name) {
        if (name != null) {
            for (FrameworkInstanceDefinition frameworkInstanceDefinition : this._frameworkInstanceDefinitions) {
                if (!name.equals(frameworkInstanceDefinition.getName())) continue;
                return frameworkInstanceDefinition;
            }
        }
        return null;
    }

    @AbstractCollection(elementTag="frameworkDefinition")
    public List<FrameworkInstanceDefinition> getFrameworkInstanceDefinitions() {
        return this._frameworkInstanceDefinitions;
    }

    @AbstractCollection(elementTag="libraryBundlificationRule")
    public List<LibraryBundlificationRule> getLibraryBundlificationRules() {
        return this._libraryBundlificationRules;
    }

    public void setFrameworkInstanceDefinitions(List<FrameworkInstanceDefinition> frameworkInstanceDefinitions) {
        this._frameworkInstanceDefinitions = frameworkInstanceDefinitions;
        ((ApplicationSettingsListener)this.dispatcher.getMulticaster()).frameworkInstancesChanged();
    }

    public void setLibraryBundlificationRules(List<LibraryBundlificationRule> libraryBundlificationRules) {
        this._libraryBundlificationRules = libraryBundlificationRules;
    }

    public void addApplicationSettingsListener(ApplicationSettingsListener listener) {
        this.dispatcher.addListener((EventListener)listener);
    }

    public void removeApplicationSettingsListener(ApplicationSettingsListener listener) {
        this.dispatcher.removeListener((EventListener)listener);
    }

    public static interface ApplicationSettingsListener
    extends EventListener {
        public void frameworkInstancesChanged();
    }
}

