/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.settings.MyErrorText;

public class CreateFrameworkInstanceDialog
extends DialogWrapper {
    private JPanel _mainPanel;
    private JComboBox _integratorComboBox;
    private JTextField _nameTextField;
    private TextFieldWithBrowseButton _baseFolderChooser;
    private JPanel _errorText;
    private JTextField myVersionField;

    private void createUIComponents() {
        this._errorText = new MyErrorText();
    }

    public CreateFrameworkInstanceDialog(FrameworkIntegratorRegistry frameworkIntegratorRegistry, String frameworkInstanceName) {
        super(true);
        this.$$$setupUI$$$();
        this.setTitle("OSGi Framework Instance");
        this.setModal(true);
        if (frameworkInstanceName != null) {
            this._nameTextField.setText(frameworkInstanceName);
        }
        FrameworkIntegrator[] integrators = frameworkIntegratorRegistry.getFrameworkIntegrators();
        this._integratorComboBox.removeAllItems();
        for (FrameworkIntegrator integrator : integrators) {
            this._integratorComboBox.addItem(integrator);
        }
        this._integratorComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CreateFrameworkInstanceDialog.this._integratorComboBox.getSelectedItem() != null && CreateFrameworkInstanceDialog.this._nameTextField.getText().length() == 0) {
                    CreateFrameworkInstanceDialog.this._nameTextField.setText(((FrameworkIntegrator)CreateFrameworkInstanceDialog.this._integratorComboBox.getSelectedItem()).getDisplayName());
                }
            }
        });
        this._nameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CreateFrameworkInstanceDialog.this.checkButtonOKEnabled();
            }
        });
        this._integratorComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateFrameworkInstanceDialog.this.checkButtonOKEnabled();
            }
        });
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this._baseFolderChooser.addBrowseFolderListener("Choose framework instance base folder", "", null, fileChooserDescriptor);
        this._baseFolderChooser.getTextField().setEditable(false);
        this._baseFolderChooser.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CreateFrameworkInstanceDialog.this.checkButtonOKEnabled();
            }
        });
        this.init();
        this.checkButtonOKEnabled();
    }

    public JComponent getPreferredFocusedComponent() {
        return this._nameTextField;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this._mainPanel;
    }

    private void checkButtonOKEnabled() {
        FrameworkIntegrator integrator = (FrameworkIntegrator)this._integratorComboBox.getSelectedItem();
        boolean isFrameworkDefinitionValid = false;
        if (integrator != null) {
            FrameworkInstanceDefinition definition = new FrameworkInstanceDefinition();
            definition.setName(this.getName());
            definition.setFrameworkIntegratorName(this.getIntegratorName());
            definition.setBaseFolder(this.getBaseFolder());
            definition.setVersion(this.getVersion());
            String errorInfoText = integrator.getFrameworkInstanceManager().checkValidity(definition);
            ((MyErrorText)this._errorText).setError(errorInfoText);
            isFrameworkDefinitionValid = errorInfoText == null || errorInfoText.length() == 0;
        }
        this.setOKActionEnabled(this._nameTextField.getText().length() > 0 && integrator != null && isFrameworkDefinitionValid);
    }

    public String getIntegratorName() {
        FrameworkIntegrator integrator = (FrameworkIntegrator)this._integratorComboBox.getSelectedItem();
        return integrator != null ? integrator.getDisplayName() : "";
    }

    public void setIntegratorName(String value) {
        int count = this._integratorComboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            FrameworkIntegrator integrator = (FrameworkIntegrator)this._integratorComboBox.getItemAt(i);
            if (!integrator.getDisplayName().equals(value)) continue;
            this._integratorComboBox.setSelectedIndex(i);
            break;
        }
    }

    public String getVersion() {
        return this.myVersionField.getText();
    }

    public void setVersion(String value) {
        this.myVersionField.setText(value);
    }

    public String getBaseFolder() {
        return this._baseFolderChooser.getText();
    }

    public void setBaseFolder(String value) {
        this._baseFolderChooser.setText(value);
    }

    public String getName() {
        return this._nameTextField.getText();
    }

    protected String getHelpId() {
        return "reference.settings.project.osgi.new.framework.instance";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this._mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(600, 220));
        jPanel.setPreferredSize(new Dimension(400, 146));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Type");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Base Folder");
        jLabel3.setDisplayedMnemonic('B');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(71, 11), null));
        this._baseFolderChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 3, null, new Dimension(42, 11), null));
        this._integratorComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this._nameTextField = jTextField2 = new JTextField();
        jTextField2.setColumns(40);
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Status", 0, 0, null, null));
        JPanel jPanel3 = this._errorText;
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Version");
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._mainPanel;
    }
}

