/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.CreateFrameworkInstanceDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkDefinitionsEditorComponent {
    private JPanel mainPanel;
    private JList frameworkInstances;
    private JButton addFramework;
    private JButton removeFramework;
    private JLabel frameworkIntegrator;
    private JLabel baseFolder;
    private JLabel frameworkInstanceName;
    private JButton editFramework;
    private JLabel version;
    private FrameworkIntegratorRegistry frameworkIntegratorRegistry;
    private FrameworkInstanceDefinition selectedFrameworkInstance;
    private boolean myModified;
    private DefaultListModel myModel;

    public FrameworkDefinitionsEditorComponent(FrameworkIntegratorRegistry frameworkIntegratorRegistry) {
        this.frameworkIntegratorRegistry = frameworkIntegratorRegistry;
        this.$$$setupUI$$$();
        this.myModel = new DefaultListModel();
        this.frameworkInstances.setModel(this.myModel);
        this.addFramework.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FrameworkDefinitionsEditorComponent.this.addFrameworkInstance();
            }
        });
        this.editFramework.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FrameworkDefinitionsEditorComponent.this.editFrameworkInstance();
            }
        });
        this.removeFramework.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FrameworkDefinitionsEditorComponent.this.removeFrameworkInstance();
            }
        });
        this.editFramework.setEnabled(this.selectedFrameworkInstance != null);
        this.frameworkInstances.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FrameworkDefinitionsEditorComponent.this.selectedFrameworkInstance = (FrameworkInstanceDefinition)FrameworkDefinitionsEditorComponent.this.frameworkInstances.getSelectedValue();
                if (FrameworkDefinitionsEditorComponent.this.selectedFrameworkInstance != null) {
                    FrameworkDefinitionsEditorComponent.this.frameworkIntegrator.setText(FrameworkDefinitionsEditorComponent.this.selectedFrameworkInstance.getFrameworkIntegratorName());
                    FrameworkDefinitionsEditorComponent.this.baseFolder.setText(FrameworkDefinitionsEditorComponent.this.selectedFrameworkInstance.getBaseFolder());
                    String theVersion = FrameworkDefinitionsEditorComponent.this.selectedFrameworkInstance.getVersion();
                    FrameworkDefinitionsEditorComponent.this.version.setText(theVersion != null && theVersion.length() > 0 ? theVersion : "latest");
                    FrameworkDefinitionsEditorComponent.this.frameworkInstanceName.setText(FrameworkDefinitionsEditorComponent.this.selectedFrameworkInstance.getName());
                }
                FrameworkDefinitionsEditorComponent.this.editFramework.setEnabled(FrameworkDefinitionsEditorComponent.this.selectedFrameworkInstance != null);
            }
        });
        this.frameworkInstances.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (FrameworkDefinitionsEditorComponent.this.selectedFrameworkInstance != null && e.getClickCount() == 2 && e.getButton() == 1) {
                    FrameworkDefinitionsEditorComponent.this.editFrameworkInstance();
                }
            }
        });
    }

    private void addFrameworkInstance() {
        String frameworkInstanceNameForCreation = null;
        CreateFrameworkInstanceDialog dialog = new CreateFrameworkInstanceDialog(this.frameworkIntegratorRegistry, frameworkInstanceNameForCreation);
        dialog.pack();
        dialog.show();
        if (dialog.isOK()) {
            FrameworkInstanceDefinition instanceDefinition = new FrameworkInstanceDefinition();
            instanceDefinition.setName(dialog.getName());
            instanceDefinition.setFrameworkIntegratorName(dialog.getIntegratorName());
            instanceDefinition.setBaseFolder(dialog.getBaseFolder());
            instanceDefinition.setVersion(dialog.getVersion());
            this.myModel.addElement(instanceDefinition);
            this.myModified = true;
            this.frameworkInstances.setSelectedValue(instanceDefinition, true);
        }
    }

    private void removeFrameworkInstance() {
        FrameworkInstanceDefinition selectedFrameworkInstance = this.selectedFrameworkInstance;
        if (selectedFrameworkInstance != null) {
            this.myModified = true;
            this.myModel.removeElement(selectedFrameworkInstance);
            this.frameworkInstances.setSelectedIndex(0);
        }
    }

    private void editFrameworkInstance() {
        FrameworkInstanceDefinition frameworkInstanceDefinition = this.selectedFrameworkInstance;
        if (frameworkInstanceDefinition == null) {
            return;
        }
        CreateFrameworkInstanceDialog dialog = new CreateFrameworkInstanceDialog(this.frameworkIntegratorRegistry, frameworkInstanceDefinition.getName());
        dialog.setIntegratorName(frameworkInstanceDefinition.getFrameworkIntegratorName());
        dialog.setBaseFolder(frameworkInstanceDefinition.getBaseFolder());
        dialog.setVersion(frameworkInstanceDefinition.getVersion());
        dialog.pack();
        dialog.show();
        if (dialog.isOK()) {
            int index = this.myModel.indexOf(this.selectedFrameworkInstance);
            this.myModel.removeElement(this.selectedFrameworkInstance);
            frameworkInstanceDefinition = new FrameworkInstanceDefinition();
            frameworkInstanceDefinition.setName(dialog.getName());
            frameworkInstanceDefinition.setFrameworkIntegratorName(dialog.getIntegratorName());
            frameworkInstanceDefinition.setBaseFolder(dialog.getBaseFolder());
            frameworkInstanceDefinition.setVersion(dialog.getVersion());
            this.myModel.add(index, frameworkInstanceDefinition);
            this.myModified = true;
            this.frameworkInstances.setSelectedValue(frameworkInstanceDefinition, true);
        }
    }

    @Nullable
    private FrameworkInstanceManager getFrameworkInstanceManager(FrameworkInstanceDefinition instanceDefinition) {
        FrameworkIntegrator frameworkIntegrator = this.frameworkIntegratorRegistry.findIntegratorByInstanceDefinition(instanceDefinition);
        if (frameworkIntegrator != null) {
            return frameworkIntegrator.getFrameworkInstanceManager();
        }
        return null;
    }

    public void resetTo(ApplicationSettings settings) {
        this.myModel.clear();
        for (FrameworkInstanceDefinition frameworkInstanceDefinition : settings.getFrameworkInstanceDefinitions()) {
            this.myModel.addElement(frameworkInstanceDefinition);
        }
        this.myModified = false;
    }

    public void applyTo(ApplicationSettings settings) {
        int instances = this.myModel.getSize();
        ArrayList<FrameworkInstanceDefinition> definitions = new ArrayList<FrameworkInstanceDefinition>(instances);
        for (int i = 0; i < instances; ++i) {
            definitions.add((FrameworkInstanceDefinition)this.frameworkInstances.getModel().getElementAt(i));
        }
        this.updateLibraries(settings.getFrameworkInstanceDefinitions(), definitions);
        settings.setFrameworkInstanceDefinitions(definitions);
        this.myModified = false;
    }

    private void updateLibraries(List<FrameworkInstanceDefinition> oldDefinitions, ArrayList<FrameworkInstanceDefinition> newDefinitions) {
        FrameworkInstanceManager frameworkInstanceManager;
        for (FrameworkInstanceDefinition oldDefinition : oldDefinitions) {
            if (newDefinitions.contains(oldDefinition) || (frameworkInstanceManager = this.getFrameworkInstanceManager(oldDefinition)) == null) continue;
            frameworkInstanceManager.removeLibraries(oldDefinition);
        }
        for (FrameworkInstanceDefinition newDefinition : newDefinitions) {
            if (oldDefinitions.contains(newDefinition) || (frameworkInstanceManager = this.getFrameworkInstanceManager(newDefinition)) == null) continue;
            frameworkInstanceManager.createLibraries(newDefinition);
        }
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JList jList;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Framework instances", 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel3.add((Component)jScrollPane, new GridConstraints(0, 0, 4, 1, 0, 3, 7, 7, null, null, null));
        this.frameworkInstances = jList = new JList();
        jList.setVisibleRowCount(6);
        jScrollPane.setViewportView(jList);
        this.addFramework = jButton3 = new JButton();
        jButton3.setText("Add...");
        jButton3.setMnemonic('A');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.removeFramework = jButton2 = new JButton();
        jButton2.setText("Remove");
        jButton2.setMnemonic('R');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.editFramework = jButton = new JButton();
        jButton.setText("Edit...");
        jButton.setMnemonic('E');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Type:");
        jLabel5.setDisplayedMnemonic('T');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.frameworkIntegrator = jLabel4 = new JLabel();
        jLabel4.setText("");
        jPanel4.add((Component)jLabel4, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Base Folder:");
        jLabel6.setDisplayedMnemonic('B');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.baseFolder = jLabel3 = new JLabel();
        jLabel3.setText("");
        jPanel4.add((Component)jLabel3, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.frameworkInstanceName = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Name:");
        jLabel7.setDisplayedMnemonic('N');
        jLabel7.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Version:");
        jPanel4.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.version = jLabel = new JLabel();
        jLabel.setText("");
        jPanel4.add((Component)jLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel5.setLabelFor(jLabel4);
        jLabel7.setLabelFor(jLabel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

