/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.osmorc.frameworkintegration.LibraryBundlificationRule;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.ManifestEditor;

public class LibraryBundlingEditorComponent {
    private JPanel mainPanel;
    private JTextField libraryRegex;
    private JButton addRuleButton;
    private JButton removeRuleButton;
    private JButton duplicateButton;
    private JButton upButton;
    private JButton downButton;
    private JList libraries;
    private ManifestEditor manifestEntries;
    private JCheckBox neverBundle;
    private JCheckBox stopAfterThisRule;
    private JPanel _manifestEntriesHolder;
    private SelectionInList<LibraryBundlificationRule> selectedRule;
    private boolean modified;
    private PropertyChangeListener beanPropertyChangeListener;
    private BeanAdapter<LibraryBundlificationRule> beanAdapter;
    private List<LibraryBundlificationRule> rules;

    public LibraryBundlingEditorComponent() {
        this.$$$setupUI$$$();
        this.addRuleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LibraryBundlificationRule newRule = new LibraryBundlificationRule();
                LibraryBundlingEditorComponent.this.rules.add(newRule);
                LibraryBundlingEditorComponent.this.selectedRule.fireIntervalAdded(LibraryBundlingEditorComponent.this.rules.size() - 1, LibraryBundlingEditorComponent.this.rules.size() - 1);
                LibraryBundlingEditorComponent.this.selectedRule.setSelection((Object)newRule);
                LibraryBundlingEditorComponent.this.notifyChanged();
            }
        });
        this.removeRuleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (LibraryBundlingEditorComponent.this.rules.size() == 1) {
                    LibraryBundlificationRule newRule = new LibraryBundlificationRule();
                    LibraryBundlingEditorComponent.this.rules.set(0, newRule);
                    LibraryBundlingEditorComponent.this.selectedRule.fireContentsChanged(0, 1);
                    LibraryBundlingEditorComponent.this.selectedRule.setSelection((Object)newRule);
                } else {
                    int newSelectionIndex;
                    int oldSelectionIndex = LibraryBundlingEditorComponent.this.selectedRule.getSelectionIndex();
                    LibraryBundlingEditorComponent.this.rules.remove(LibraryBundlingEditorComponent.this.selectedRule.getValue());
                    LibraryBundlingEditorComponent.this.selectedRule.fireIntervalRemoved(LibraryBundlingEditorComponent.this.rules.size(), LibraryBundlingEditorComponent.this.rules.size());
                    int n = newSelectionIndex = oldSelectionIndex > 0 ? oldSelectionIndex - 1 : oldSelectionIndex;
                    if (newSelectionIndex == oldSelectionIndex) {
                        LibraryBundlingEditorComponent.this.selectedRule.clearSelection();
                    }
                    LibraryBundlingEditorComponent.this.selectedRule.setSelectionIndex(newSelectionIndex);
                }
                LibraryBundlingEditorComponent.this.notifyChanged();
            }
        });
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LibraryBundlificationRule rule = (LibraryBundlificationRule)((Object)LibraryBundlingEditorComponent.this.selectedRule.getSelection());
                if (rule != null) {
                    LibraryBundlificationRule newRule = rule.copy();
                    int selectedIndex = LibraryBundlingEditorComponent.this.selectedRule.getSelectionIndex();
                    LibraryBundlingEditorComponent.this.rules.add(selectedIndex, newRule);
                    LibraryBundlingEditorComponent.this.selectedRule.fireIntervalAdded(selectedIndex, selectedIndex);
                    LibraryBundlingEditorComponent.this.notifyChanged();
                }
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int selectionIndex = LibraryBundlingEditorComponent.this.selectedRule.getSelectionIndex();
                if (selectionIndex > 0) {
                    LibraryBundlificationRule ruleToMove = (LibraryBundlificationRule)((Object)LibraryBundlingEditorComponent.this.rules.get(selectionIndex));
                    LibraryBundlingEditorComponent.this.rules.set(selectionIndex, LibraryBundlingEditorComponent.this.rules.get(selectionIndex - 1));
                    LibraryBundlingEditorComponent.this.rules.set(selectionIndex - 1, ruleToMove);
                    LibraryBundlingEditorComponent.this.selectedRule.fireContentsChanged(selectionIndex - 1, selectionIndex);
                    LibraryBundlingEditorComponent.this.selectedRule.setSelectionIndex(selectionIndex - 1);
                    LibraryBundlingEditorComponent.this.notifyChanged();
                }
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int selectionIndex = LibraryBundlingEditorComponent.this.selectedRule.getSelectionIndex();
                if (selectionIndex < LibraryBundlingEditorComponent.this.rules.size() - 1) {
                    LibraryBundlificationRule ruleToMove = (LibraryBundlificationRule)((Object)LibraryBundlingEditorComponent.this.rules.get(selectionIndex));
                    LibraryBundlingEditorComponent.this.rules.set(selectionIndex, LibraryBundlingEditorComponent.this.rules.get(selectionIndex + 1));
                    LibraryBundlingEditorComponent.this.rules.set(selectionIndex + 1, ruleToMove);
                    LibraryBundlingEditorComponent.this.selectedRule.fireContentsChanged(selectionIndex, selectionIndex + 1);
                    LibraryBundlingEditorComponent.this.selectedRule.setSelectionIndex(selectionIndex + 1);
                    LibraryBundlingEditorComponent.this.notifyChanged();
                }
            }
        });
        DataContext dataContext = DataManager.getInstance().getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        this.manifestEntries = new ManifestEditor(project, "");
        Bindings.bind((JComponent)((Object)this.manifestEntries), (String)"text", (ValueModel)this.beanAdapter.getValueModel("additionalProperties"));
        this._manifestEntriesHolder.add((Component)((Object)this.manifestEntries), "Center");
        this.beanAdapter.addBeanPropertyChangeListener(this.beanPropertyChangeListener);
    }

    private void notifyChanged() {
        this.modified = true;
    }

    public void applyTo(ApplicationSettings settings) {
        settings.setLibraryBundlificationRules(this.rules);
        this.modified = false;
    }

    public void dispose() {
        this.manifestEntries = null;
        this._manifestEntriesHolder.removeAll();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void resetTo(ApplicationSettings settings) {
        this.rules = new ArrayList<LibraryBundlificationRule>(settings.getLibraryBundlificationRules());
        this.selectedRule.setList(this.rules);
        this.selectedRule.setSelectionIndex(0);
        this.modified = false;
    }

    private void createUIComponents() {
        this.selectedRule = new SelectionInList();
        this.libraries = BasicComponentFactory.createList(this.selectedRule);
        this.beanAdapter = new BeanAdapter((Object)new LibraryBundlificationRule());
        this.libraryRegex = BasicComponentFactory.createTextField((ValueModel)this.beanAdapter.getValueModel("ruleRegex"), (boolean)false);
        this.neverBundle = BasicComponentFactory.createCheckBox((ValueModel)this.beanAdapter.getValueModel("doNotBundle"), (String)"");
        this.stopAfterThisRule = BasicComponentFactory.createCheckBox((ValueModel)this.beanAdapter.getValueModel("stopAfterThisRule"), (String)"");
        this.selectedRule.addValueChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LibraryBundlingEditorComponent.this.beanAdapter.setBean(LibraryBundlingEditorComponent.this.selectedRule.getSelection());
            }
        });
        this.beanPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LibraryBundlingEditorComponent.this.selectedRule.fireContentsChanged(LibraryBundlingEditorComponent.this.selectedRule.getSelectionIndex(), 1);
                LibraryBundlingEditorComponent.this.notifyChanged();
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JPanel jPanel2;
        this.createUIComponents();
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("settings.libbundle.libregex"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField = this.libraryRegex;
        jPanel2.add((Component)jTextField, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("settings.libbundle.manifest"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 4, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("settings.libbundle.settings"), 0, 0, null, null));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setRollover(false);
        jToolBar.setFloatable(false);
        ((Component)jToolBar).setEnabled(true);
        jToolBar.setBorderPainted(false);
        jToolBar.putClientProperty("JToolBar.isRollover", new Boolean(false));
        jPanel3.add((Component)jToolBar, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 0, null, new Dimension(-1, 20), null));
        this.addRuleButton = jButton5 = new JButton();
        jButton5.setText("");
        jButton5.setIcon(new ImageIcon(this.getClass().getResource("/general/add.png")));
        Component component = jToolBar.add(jButton5);
        this.removeRuleButton = jButton4 = new JButton();
        jButton4.setText("");
        jButton4.setIcon(new ImageIcon(this.getClass().getResource("/general/remove.png")));
        jButton4.putClientProperty("html.disable", new Boolean(false));
        jButton4.putClientProperty("hideActionText", new Boolean(false));
        Component component2 = jToolBar.add(jButton4);
        this.duplicateButton = jButton3 = new JButton();
        jButton3.setText("");
        jButton3.setIcon(new ImageIcon(this.getClass().getResource("/actions/copy.png")));
        Component component3 = jToolBar.add(jButton3);
        this.upButton = jButton2 = new JButton();
        jButton2.setText("");
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/actions/moveUp.png")));
        Component component4 = jToolBar.add(jButton2);
        this.downButton = jButton = new JButton();
        jButton.setText("");
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/actions/moveDown.png")));
        Component component5 = jToolBar.add(jButton);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel3.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JList jList = this.libraries;
        jScrollPane.setViewportView(jList);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Process no further rules");
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JCheckBox jCheckBox = this.stopAfterThisRule;
        jCheckBox.setText("");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JCheckBox jCheckBox2 = this.neverBundle;
        jCheckBox2.setText("");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("settings.libbundle.dontbundle"));
        jPanel2.add((Component)jLabel4, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this._manifestEntriesHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

