/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.ManifestFileTypeFactory;

public class ManifestEditor
extends EditorTextField
implements Disposable {
    private MyDocumentAdapter listener;

    public ManifestEditor(@NotNull Project project, String text) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/settings/ManifestEditor.<init> must not be null");
        }
        super("", project, (FileType)ManifestFileTypeFactory.MANIFEST);
        this.listener = new MyDocumentAdapter();
        this.addDocumentListener((DocumentListener)this.listener);
        this.setText(text);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        PsiFile file = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("*.MF", (FileType)ManifestFileTypeFactory.MANIFEST, (CharSequence)text, -1L, true);
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
        this.setNewDocumentAndFileType((FileType)ManifestFileTypeFactory.MANIFEST, document);
    }

    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        editor.setOneLineMode(false);
        editor.setVerticalScrollbarVisible(true);
        return editor;
    }

    public void dispose() {
        this.removeDocumentListener((DocumentListener)this.listener);
    }

    private class MyDocumentAdapter
    extends DocumentAdapter {
        private MyDocumentAdapter() {
        }

        public void documentChanged(DocumentEvent e) {
            ManifestEditor.this.firePropertyChange("text", null, null);
        }
    }
}

