/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@State(name="Osmorc", storages={@Storage(id="other", file="$PROJECT_FILE$")})
public class ProjectSettings
implements PersistentStateComponent<ProjectSettings> {
    private EventDispatcher<ProjectSettingsListener> dispatcher = EventDispatcher.create(ProjectSettingsListener.class);
    @Nullable
    private String _frameworkInstanceName;
    private boolean _createFrameworkInstanceModule;
    @NotNull
    private String _defaultManifestFileLocation = "META-INF/MANIFEST.MF";

    public static ProjectSettings getInstance(Project project) {
        return (ProjectSettings)ServiceManager.getService((Project)project, ProjectSettings.class);
    }

    @Nullable
    public String getFrameworkInstanceName() {
        return this._frameworkInstanceName;
    }

    public void setFrameworkInstanceName(@Nullable String frameworkInstanceName) {
        this._frameworkInstanceName = frameworkInstanceName;
        ((ProjectSettingsListener)this.dispatcher.getMulticaster()).projectSettingsChanged();
    }

    @NotNull
    public ProjectSettings getState() {
        ProjectSettings projectSettings = this;
        if (projectSettings == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/settings/ProjectSettings.getState must not return null");
        }
        return projectSettings;
    }

    public void loadState(@NotNull ProjectSettings state) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/settings/ProjectSettings.loadState must not be null");
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public void setCreateFrameworkInstanceModule(boolean selected) {
        this._createFrameworkInstanceModule = selected;
        ((ProjectSettingsListener)this.dispatcher.getMulticaster()).projectSettingsChanged();
    }

    public boolean isCreateFrameworkInstanceModule() {
        return this._createFrameworkInstanceModule;
    }

    public void setDefaultManifestFileLocation(@NotNull String defaultManifestFileLocation) {
        if (defaultManifestFileLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/settings/ProjectSettings.setDefaultManifestFileLocation must not be null");
        }
        this._defaultManifestFileLocation = defaultManifestFileLocation;
        if (this._defaultManifestFileLocation.equals("META-INF")) {
            this._defaultManifestFileLocation = "META-INF/MANIFEST.MF";
        }
        ((ProjectSettingsListener)this.dispatcher.getMulticaster()).projectSettingsChanged();
    }

    public void addProjectSettingsListener(ProjectSettingsListener listener) {
        this.dispatcher.addListener((EventListener)listener);
    }

    public void removeProjectSettingsListener(ProjectSettingsListener listener) {
        this.dispatcher.removeListener((EventListener)listener);
    }

    @NotNull
    public String getDefaultManifestFileLocation() {
        String string = this._defaultManifestFileLocation;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/settings/ProjectSettings.getDefaultManifestFileLocation must not return null");
        }
        return string;
    }

    public static interface ProjectSettingsListener
    extends EventListener {
        public void projectSettingsChanged();
    }
}

