/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.FrameworkInstanceCellRenderer;
import org.osmorc.settings.ProjectSettings;

public class ProjectSettingsEditorComponent
implements ApplicationSettings.ApplicationSettingsListener {
    private boolean myModified;
    private ProjectSettings mySettings;
    private UserActivityWatcher myWatcher;
    private JPanel mainPanel;
    private JComboBox frameworkInstance;
    private JCheckBox createFrameworkInstanceModule;
    private JComboBox defaultManifestFileLocation;

    public ProjectSettingsEditorComponent() {
        this.$$$setupUI$$$();
        this.frameworkInstance.setRenderer(new FrameworkInstanceCellRenderer(){

            protected boolean isInstanceDefined(FrameworkInstanceDefinition instance) {
                List<FrameworkInstanceDefinition> instanceDefinitions = ApplicationSettings.getInstance().getFrameworkInstanceDefinitions();
                for (FrameworkInstanceDefinition instanceDefinition : instanceDefinitions) {
                    if (!instance.equals(instanceDefinition)) continue;
                    return true;
                }
                return false;
            }
        });
        this.myWatcher = new UserActivityWatcher();
        this.myWatcher.register((Component)this.mainPanel);
        this.myWatcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                ProjectSettingsEditorComponent.this.myModified = true;
            }
        });
        this.defaultManifestFileLocation.setEditable(true);
        this.defaultManifestFileLocation.addItem("META-INF");
        ApplicationSettings.getInstance().addApplicationSettingsListener(this);
    }

    public void applyTo(ProjectSettings settings) {
        FrameworkInstanceDefinition instanceDefinition;
        settings.setCreateFrameworkInstanceModule(this.createFrameworkInstanceModule.isSelected());
        String fileLocation = (String)this.defaultManifestFileLocation.getSelectedItem();
        if (fileLocation != null) {
            settings.setDefaultManifestFileLocation(fileLocation);
        }
        if ((instanceDefinition = (FrameworkInstanceDefinition)this.frameworkInstance.getSelectedItem()) != null) {
            settings.setFrameworkInstanceName(instanceDefinition.getName());
        }
    }

    public void dispose() {
        this.myWatcher = null;
        ApplicationSettings.getInstance().removeApplicationSettingsListener(this);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void resetTo(ProjectSettings settings) {
        this.mySettings = settings;
        this.refreshFrameworkInstanceCombobox();
        this.defaultManifestFileLocation.setSelectedItem(this.mySettings.getDefaultManifestFileLocation());
        this.createFrameworkInstanceModule.setSelected(this.mySettings.isCreateFrameworkInstanceModule());
        this.myModified = false;
    }

    private synchronized void refreshFrameworkInstanceCombobox() {
        if (this.mySettings == null) {
            return;
        }
        this.frameworkInstance.removeAllItems();
        List<FrameworkInstanceDefinition> instanceDefinitions = ApplicationSettings.getInstance().getFrameworkInstanceDefinitions();
        String frameworkInstanceName = this.mySettings.getFrameworkInstanceName();
        FrameworkInstanceDefinition projectFrameworkInstance = null;
        for (FrameworkInstanceDefinition instanceDefinition : instanceDefinitions) {
            this.frameworkInstance.addItem(instanceDefinition);
            if (!instanceDefinition.getName().equals(frameworkInstanceName)) continue;
            projectFrameworkInstance = instanceDefinition;
        }
        if (projectFrameworkInstance == null && frameworkInstanceName != null) {
            projectFrameworkInstance = new FrameworkInstanceDefinition();
            projectFrameworkInstance.setName(frameworkInstanceName);
            projectFrameworkInstance.setDefined(false);
            this.frameworkInstance.addItem(projectFrameworkInstance);
        }
        this.frameworkInstance.setSelectedItem(projectFrameworkInstance);
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void frameworkInstancesChanged() {
        boolean modified = this.myModified;
        this.refreshFrameworkInstanceCombobox();
        this.myModified = modified;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Framework Instance");
        jLabel.setDisplayedMnemonic('F');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.frameworkInstance = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.createFrameworkInstanceModule = jCheckBox = new JCheckBox();
        jCheckBox.setText("Create and maintain the module FrameworkInstance");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Default manifest file location (relative to a module's content root)");
        jLabel2.setDisplayedMnemonic('D');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.defaultManifestFileLocation = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

